package tocraft.walkers;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import org.lwjgl.glfw.GLFW;
import tocraft.craftedcore.event.client.ClientPlayerEvents;
import tocraft.craftedcore.event.client.ClientTickEvents;
import tocraft.craftedcore.event.client.RenderEvents;
import tocraft.craftedcore.registration.KeyBindingRegistry;
import tocraft.walkers.ability.AbilityOverlayRenderer;
import tocraft.walkers.api.model.EntityArms;
import tocraft.walkers.api.model.EntityUpdaters;
import tocraft.walkers.api.platform.ApiLevel;
import tocraft.walkers.eventhandler.ClientRespawnHandler;
import tocraft.walkers.impl.tick.KeyPressHandler;
import tocraft.walkers.network.ClientNetworking;
import tocraft.walkers.screen.hud.OverlayEventHandler;
import tocraft.walkers.screen.hud.VariantMenu;

@Environment(EnvType.CLIENT)
public class WalkersClient {
    public static boolean isRenderingVariantsMenu = false;
    public static int variantOffset = 0;

    public static final class_304 UNLOCK_KEY = new class_304("key.walkers_unlock", class_3675.class_307.field_1668, GLFW.GLFW_KEY_U, "key.categories.walkers");
    public static final class_304 TRANSFORM_KEY = new class_304("key.walkers", class_3675.class_307.field_1668, GLFW.GLFW_KEY_G, "key.categories.walkers");
    public static final class_304 ABILITY_KEY = new class_304("key.walkers_ability", class_3675.class_307.field_1668, GLFW.GLFW_KEY_R, "key.categories.walkers");
    public static final class_304 VARIANTS_MENU_KEY = new class_304("key.walkers_variants", class_3675.class_307.field_1668, GLFW.GLFW_KEY_V, "key.categories.walkers");


    public void initialize() {
        KeyBindingRegistry.register(ABILITY_KEY);
        KeyBindingRegistry.register(TRANSFORM_KEY);
        KeyBindingRegistry.register(UNLOCK_KEY);
        KeyBindingRegistry.register(VARIANTS_MENU_KEY);

        // Register client-side event handlers
        EntityUpdaters.init();
        AbilityOverlayRenderer.register();
        EntityArms.init();

        // Register event handlers
        ClientTickEvents.CLIENT_PRE.register(new KeyPressHandler());
        RenderEvents.HUD_RENDERING.register((guiGraphics, tickDelta) -> new VariantMenu().render(guiGraphics));
        ClientNetworking.registerPacketHandlers();

        OverlayEventHandler.initialize();

        ClientPlayerEvents.CLIENT_PLAYER_RESPAWN.register(new ClientRespawnHandler());

        ClientPlayerEvents.CLIENT_PLAYER_QUIT.register(player -> {
            if (player != null && ApiLevel.getClientLevel() != null) {
                ApiLevel.ON_API_LEVEL_CHANGE_EVENT.invoke().onApiLevelChange(ApiLevel.getClientLevel());
            }
        });
    }
}
