/*
 * Decompiled with CFR 0.152.
 */
package dev.tocraft.skinshifter.mixin.client;

import dev.tocraft.skinshifter.SkinShifter;
import dev.tocraft.skinshifter.data.SkinPlayerData;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.craftedcore.platform.PlayerProfile;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={AbstractClientPlayer.class})
public class AbstractClientPlayerMixin {
    @Inject(method={"getSkinTextureLocation"}, at={@At(value="RETURN")}, cancellable=true)
    public void setToNewSkin(CallbackInfoReturnable<ResourceLocation> cir) {
        PlayerProfile skin = SkinPlayerData.getSkin((Player)this);
        if (skin != null && skin.skin() != null) {
            cir.setReturnValue((Object)skin.getSkinId());
        }
    }

    @Inject(method={"getModelName"}, at={@At(value="RETURN")}, cancellable=true)
    public void setModelType(CallbackInfoReturnable<String> cir) {
        PlayerProfile skin = SkinPlayerData.getSkin((Player)this);
        if (null != skin && skin.skin() != null) {
            cir.setReturnValue((Object)(skin.isSlim() ? "slim" : "default"));
        }
    }

    @Inject(method={"getCloakTextureLocation"}, at={@At(value="RETURN")}, cancellable=true)
    public void setToNewCloak(CallbackInfoReturnable<ResourceLocation> cir) {
        PlayerProfile skin;
        if (SkinShifter.CONFIG.changeCape && (skin = SkinPlayerData.getSkin((Player)this)) != null && skin.cape() != null) {
            cir.setReturnValue((Object)skin.getCapeId());
        }
    }
}

