package tocraft.remorphed.screen.widget;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Wolf;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.impl.PlayerMorph;
import tocraft.remorphed.network.NetworkHandler;
import tocraft.remorphed.screen.RemorphedScreen;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.variant.ShapeType;
import tocraft.walkers.api.variant.TypeProvider;
import tocraft.walkers.api.variant.TypeProviderRegistry;
import tocraft.walkers.network.impl.SwapVariantPackets;

import java.util.Objects;

@Environment(EnvType.CLIENT)
public class SpecialShapeWidget extends AbstractButton {
    private final RemorphedScreen parent;
    private final boolean isCurrent;
    private final boolean isAvailable;

    public SpecialShapeWidget(int x, int y, int width, int height, RemorphedScreen parent) {
        super(x, y, width, height, Component.m_130674_(""));
        this.parent = parent;

        // check if current shape is the special shape
        CompoundTag nbt = new CompoundTag();
        if (Minecraft.m_91087_().f_91074_ != null && PlayerShape.getCurrentShape(Minecraft.m_91087_().f_91074_) instanceof Wolf wolf)
            wolf.m_20240_(nbt);
        this.isCurrent = nbt.m_128441_("isSpecial") && nbt.m_128471_("isSpecial");
        this.isAvailable = Remorphed.canUseEveryShape(Minecraft.m_91087_().f_91074_) || (PlayerMorph.getUnlockedShapes(Minecraft.m_91087_().f_91074_)).keySet().stream().anyMatch(type -> type.getEntityType().equals(EntityType.f_20499_));

        m_257544_(Tooltip.m_257550_(Component.m_237115_(isAvailable ? "remorphed.special_shape_available" : "remorphed.special_shape_unavailable")));
    }

    @Override
    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.m_280411_(Remorphed.id("textures/gui/wolf.png"), m_252754_(), m_252907_(), m_5711_(), m_93694_(), 0, 0, 15, 15, 15, 15);

        if (!isCurrent && !isAvailable)
            guiGraphics.m_280411_(Remorphed.id("textures/gui/unavailable.png"), m_252754_(), m_252907_(), m_5711_(), m_93694_(), 0, 0, 15, 15, 15, 15);
    }

    @Override
    public void m_5691_() {
        if (!isCurrent && isAvailable && Walkers.hasSpecialShape(Minecraft.m_91087_().m_91094_().m_240411_())) {
            // get variant range
            TypeProvider<Wolf> typeProvider = TypeProviderRegistry.getProvider(EntityType.f_20499_);
            int range = typeProvider != null ? typeProvider.getRange() : -1;
            // swap to variant
            NetworkHandler.sendSwap2ndShapeRequest(Objects.requireNonNull(ShapeType.from(EntityType.f_20499_, -1)));
            SwapVariantPackets.sendSwapRequest(range + 1);
            parent.m_7379_();
        }
    }

    @Override
    public void m_168797_(NarrationElementOutput builder) {

    }
}
