package tocraft.remorphed.screen.widget;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.network.NetworkHandler;
import tocraft.remorphed.screen.RemorphedScreen;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.variant.ShapeType;
import tocraft.walkers.traits.ShapeTrait;
import tocraft.walkers.traits.TraitRegistry;


import java.util.ArrayList;
import java.util.List;

@Environment(EnvType.CLIENT)
public class EntityWidget<T extends LivingEntity> extends AbstractButton {

    private final ShapeType<T> type;
    private final T entity;
    private final int size;
    private final RemorphedScreen parent;
    private boolean crashed;
    private boolean isFavorite;
    private final boolean isCurrent;

    public EntityWidget(float x, float y, float width, float height, ShapeType<T> type, T entity, RemorphedScreen parent, boolean isFavorite, boolean current) {
        super((int) x, (int) y, (int) width, (int) height, Component.m_130674_("")); // int x, int y, int width, int height, message
        this.type = type;
        this.entity = entity;
        size = (int) (25 * (1 / (Math.max(entity.m_20206_(), entity.m_20205_()))));
        entity.m_146915_(true);
        this.parent = parent;
        this.isFavorite = isFavorite;
        this.isCurrent = current;
        m_257544_(Tooltip.m_257550_(ShapeType.createTooltipText(entity)));
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean bl = mouseX >= (double) this.m_252754_() && mouseX < (double) (this.m_252754_() + this.f_93618_) && mouseY >= (double) this.m_252907_() && mouseY < (double) (this.m_252907_() + this.f_93619_);
        if (bl && Minecraft.m_91087_().f_91074_ != null) {
            // switch to new shape
            if (button == 0 && !type.equals(ShapeType.from(PlayerShape.getCurrentShape(Minecraft.m_91087_().f_91074_)))) {
                // Update 2nd Shape
                NetworkHandler.sendSwap2ndShapeRequest(type);
                // close active screen handler
                parent.m_7379_();
            }
            // Add to favorites
            else if (button == 1) {
                isFavorite = !isFavorite;
                NetworkHandler.sendFavoriteRequest(type, isFavorite);
            }
        }

        return super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    public void m_87963_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        if (!crashed) {
            if (Remorphed.displayTraitsInMenu) {
                // Render Trait Icons first
                int blitOffset = 0;
                int rowIndex = 0;
                List<ResourceLocation> renderedTraits = new ArrayList<>();
                for (ShapeTrait<T> trait : TraitRegistry.getAll(entity)) {
                    if (trait != null && trait.getIcon() != null && (!renderedTraits.contains(trait.getId()) || trait.iconMightDiffer())) {
                        context.m_280159_(m_252754_() + rowIndex, m_252907_() + blitOffset, 0, 18, 18, trait.getIcon());
                        // prevent infinite traits to be rendered
                        if (blitOffset >= m_93694_() - 18) {
                            rowIndex += 18;
                            blitOffset = 0;
                        } else {
                            blitOffset += 18;
                        }
                        if (rowIndex >= m_5711_() - 18) {
                            break;
                        }
                        renderedTraits.add(trait.getId());
                    }
                }
            }

            // Some entities (namely Aether mobs) crash when rendered in a GUI.
            // Unsure as to the cause, but this try/catch should prevent the game from entirely dipping out.
            try {
                // ARGH
                InventoryScreen.m_280432_(context, m_252754_() + (float) this.m_5711_() / 2, (int) (m_252907_() + this.m_93694_() * .75f), size, new Vector3f(), new Quaternionf().rotationXYZ(0.43633232F, (float) Math.PI, (float) Math.PI), null, entity);
            } catch (Exception e) {
                Remorphed.LOGGER.error("Error while rendering {}", ShapeType.createTooltipText(entity).getString(), e);
                crashed = true;
                MultiBufferSource.BufferSource immediate = Minecraft.m_91087_().m_91269_().m_110104_();
                immediate.m_109911_();
                EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
                entityRenderDispatcher.m_114468_(true);
                RenderSystem.getModelViewStack().m_85849_();
                Lighting.m_84931_();
            }

            // Render selected outline
            if (isCurrent) {
                context.m_280411_(Remorphed.id("textures/gui/selected.png"), m_252754_(), m_252907_(), m_5711_(), m_93694_(), 0, 0, 48, 32, 48, 32);
            }
            // Render favorite
            if (isFavorite) {
                context.m_280411_(Remorphed.id("textures/gui/favorite.png"), m_252754_(), m_252907_(), m_5711_(), m_93694_(), 0, 0, 48, 32, 48, 32);
            }
        }
    }

    @Override
    public void m_5691_() {

    }

    @Override
    public void m_168797_(NarrationElementOutput builder) {

    }
}
