package tocraft.remorphed.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.LiteralCommandNode;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.Commands.CommandSelection;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.event.common.CommandEvents;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.impl.PlayerMorph;
import tocraft.walkers.api.PlayerShapeChanger;
import tocraft.walkers.api.variant.ShapeType;

public class RemorphedCommand implements CommandEvents.CommandRegistration {
    private static int hasShape(CommandSourceStack source, ServerPlayer player, ResourceLocation id, @Nullable CompoundTag nbt) {
        ShapeType<LivingEntity> type = getType(source.m_81372_(), id, nbt);
        Component name = Component.m_237115_(type.getEntityType().m_20675_());

        if (PlayerMorph.getUnlockedShapes(player).containsKey(type)) {
            source.m_243053_(Component.m_237110_(Remorphed.MODID + ".hasShape_success",
                    player.m_5446_(), name));

            return 1;
        } else
            source.m_243053_(Component.m_237110_(Remorphed.MODID + ".hasShape_fail", player.m_5446_(), name));

        return 0;
    }

    private static void removeShape(CommandSourceStack source, ServerPlayer player, ResourceLocation id, @Nullable CompoundTag nbt) {
        ShapeType<LivingEntity> type = getType(source.m_81372_(), id, nbt);
        Component name = Component.m_237115_(type.getEntityType().m_20675_());

        PlayerMorph.getUnlockedShapes(player).remove(type);

        source.m_243053_(Component.m_237110_(Remorphed.MODID + ".removeShape", name, player.m_5446_()));
    }

    private static void addShape(CommandSourceStack source, ServerPlayer player, ResourceLocation id, @Nullable CompoundTag nbt) {
        ShapeType<LivingEntity> type = getType(source.m_81372_(), id, nbt);
        Component name = Component.m_237115_(type.getEntityType().m_20675_());

        PlayerMorph.getUnlockedShapes(player).put(type, Remorphed.getKillToUnlock(type.getEntityType()));

        source.m_243053_(Component.m_237110_(Remorphed.MODID + ".addShape", player.m_5446_(), name));
    }

    private static void clearShapes(CommandSourceStack source, ServerPlayer player) {
        PlayerMorph.getUnlockedShapes(player).clear();

        source.m_243053_(Component.m_237110_(Remorphed.MODID + ".clearShapes", player.m_5446_()));
        PlayerShapeChanger.change2ndShape(player, null);
    }

    @SuppressWarnings("unchecked")
    private static ShapeType<LivingEntity> getType(ServerLevel serverLevel, ResourceLocation id, @Nullable CompoundTag nbt) {
        ShapeType<LivingEntity> type = ShapeType.from((EntityType<LivingEntity>) BuiltInRegistries.f_256780_.m_7745_(id));

        if (nbt != null) {
            CompoundTag copy = nbt.m_6426_();
            copy.m_128359_("id", id.toString());
            Entity loaded = EntityType.m_20645_(copy, serverLevel, it -> it);
            if (loaded instanceof LivingEntity living) {
                type = new ShapeType<>(living);
            }
        }

        return type;
    }

    @Override
    public void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext registry, CommandSelection selection) {

        LiteralCommandNode<CommandSourceStack> rootNode = Commands.m_82127_(Remorphed.MODID)
                .requires(source -> source.m_6761_(2)).build();

        /*
         * Used to remove a unlocked shape of the specified Player.
         */
        LiteralCommandNode<CommandSourceStack> removeShape = Commands.m_82127_("removeShape")
                .then(Commands.m_82129_("player", EntityArgument.m_91470_())
                        .then(Commands.m_82129_("shape", ResourceArgument.m_247102_(registry, Registries.f_256939_))
                                .suggests(SuggestionProviders.f_121645_).executes(context -> {
                                    removeShape(context.getSource(), EntityArgument.m_91474_(context, "player"),
                                            EntityType.m_20613_(ResourceArgument
                                                    .m_247713_(context, "shape").m_203334_()),
                                            null);
                                    return 1;
                                }).then(Commands.m_82129_("nbt", CompoundTagArgument.m_87657_())
                                        .executes(context -> {
                                            CompoundTag nbt = CompoundTagArgument.m_87660_(context, "nbt");

                                            removeShape(context.getSource(),
                                                    EntityArgument.m_91474_(context, "player"),
                                                    EntityType.m_20613_(ResourceArgument
                                                            .m_247713_(context, "shape").m_203334_()),
                                                    nbt);

                                            return 1;
                                        }))))
                .build();

        /*
         * Used to add a shape to the specified Player.
         */
        LiteralCommandNode<CommandSourceStack> addShape = Commands.m_82127_("addShape")
                .then(Commands.m_82129_("player", EntityArgument.m_91470_())
                        .then(Commands.m_82129_("shape", ResourceArgument.m_247102_(registry, Registries.f_256939_))
                                .suggests(SuggestionProviders.f_121645_).executes(context -> {
                                    addShape(context.getSource(), EntityArgument.m_91474_(context, "player"),
                                            EntityType.m_20613_(ResourceArgument
                                                    .m_247713_(context, "shape").m_203334_()),
                                            null);
                                    return 1;
                                }).then(Commands.m_82129_("nbt", CompoundTagArgument.m_87657_())
                                        .executes(context -> {
                                            CompoundTag nbt = CompoundTagArgument.m_87660_(context, "nbt");

                                            addShape(context.getSource(),
                                                    EntityArgument.m_91474_(context, "player"),
                                                    EntityType.m_20613_(ResourceArgument
                                                            .m_247713_(context, "shape").m_203334_()),
                                                    nbt);

                                            return 1;
                                        }))))
                .build();

        /*
         * Used to remove all unlocked shapes of the specified Player.
         */
        LiteralCommandNode<CommandSourceStack> clearShapes = Commands.m_82127_("clearShapes")
                .then(Commands.m_82129_("player", EntityArgument.m_91470_()).executes(context -> {
                    clearShapes(context.getSource(), EntityArgument.m_91474_(context, "player"));
                    return 1;
                })).build();

        /*
         * Used to check if a player has unlocked a specific shape
         */
        LiteralCommandNode<CommandSourceStack> hasShape = Commands.m_82127_("hasShape")
                .then(Commands.m_82129_("player", EntityArgument.m_91470_())
                        .then(Commands.m_82129_("shape", ResourceArgument.m_247102_(registry, Registries.f_256939_))
                                .suggests(SuggestionProviders.f_121645_).executes(context -> hasShape(context.getSource(), EntityArgument.m_91474_(context, "player"),
                                        EntityType.m_20613_(ResourceArgument
                                                .m_247713_(context, "shape").m_203334_()),
                                        null)).then(Commands.m_82129_("nbt", CompoundTagArgument.m_87657_())
                                        .executes(context -> {
                                            CompoundTag nbt = CompoundTagArgument.m_87660_(context, "nbt");

                                            return hasShape(context.getSource(),
                                                    EntityArgument.m_91474_(context, "player"),
                                                    EntityType.m_20613_(ResourceArgument
                                                            .m_247713_(context, "shape").m_203334_()),
                                                    nbt);
                                        }))))
                .build();

        rootNode.addChild(removeShape);
        rootNode.addChild(addShape);
        rootNode.addChild(clearShapes);
        rootNode.addChild(hasShape);

        dispatcher.getRoot().addChild(rootNode);

    }
}
