/*
 * Decompiled with CFR 0.152.
 */
package tocraft.remorphed.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.event.common.CommandEvents;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.impl.PlayerMorph;
import tocraft.walkers.api.PlayerShapeChanger;
import tocraft.walkers.api.variant.ShapeType;

public class RemorphedCommand
implements CommandEvents.CommandRegistration {
    private static int hasShape(CommandSourceStack source, ServerPlayer player, ResourceLocation id, @Nullable CompoundTag nbt) {
        ShapeType<LivingEntity> type = RemorphedCommand.getType(source.m_81372_(), id, nbt);
        MutableComponent name = Component.m_237115_((String)type.getEntityType().m_20675_());
        if (PlayerMorph.getUnlockedShapes((Player)player).containsKey(type)) {
            source.m_243053_((Component)Component.m_237110_((String)"remorphed.hasShape_success", (Object[])new Object[]{player.m_5446_(), name}));
            return 1;
        }
        source.m_243053_((Component)Component.m_237110_((String)"remorphed.hasShape_fail", (Object[])new Object[]{player.m_5446_(), name}));
        return 0;
    }

    private static void removeShape(CommandSourceStack source, ServerPlayer player, ResourceLocation id, @Nullable CompoundTag nbt) {
        ShapeType<LivingEntity> type = RemorphedCommand.getType(source.m_81372_(), id, nbt);
        MutableComponent name = Component.m_237115_((String)type.getEntityType().m_20675_());
        PlayerMorph.getUnlockedShapes((Player)player).remove(type);
        source.m_243053_((Component)Component.m_237110_((String)"remorphed.removeShape", (Object[])new Object[]{name, player.m_5446_()}));
    }

    private static void addShape(CommandSourceStack source, ServerPlayer player, ResourceLocation id, @Nullable CompoundTag nbt) {
        ShapeType<LivingEntity> type = RemorphedCommand.getType(source.m_81372_(), id, nbt);
        MutableComponent name = Component.m_237115_((String)type.getEntityType().m_20675_());
        PlayerMorph.getUnlockedShapes((Player)player).put(type, Remorphed.getKillToUnlock(type.getEntityType()));
        source.m_243053_((Component)Component.m_237110_((String)"remorphed.addShape", (Object[])new Object[]{player.m_5446_(), name}));
    }

    private static void clearShapes(CommandSourceStack source, ServerPlayer player) {
        PlayerMorph.getUnlockedShapes((Player)player).clear();
        source.m_243053_((Component)Component.m_237110_((String)"remorphed.clearShapes", (Object[])new Object[]{player.m_5446_()}));
        PlayerShapeChanger.change2ndShape((ServerPlayer)player, null);
    }

    private static ShapeType<LivingEntity> getType(ServerLevel serverLevel, ResourceLocation id, @Nullable CompoundTag nbt) {
        ShapeType type = ShapeType.from((EntityType)((EntityType)BuiltInRegistries.f_256780_.m_7745_(id)));
        if (nbt != null) {
            CompoundTag copy = nbt.m_6426_();
            copy.m_128359_("id", id.toString());
            Entity loaded = EntityType.m_20645_((CompoundTag)copy, (Level)serverLevel, it -> it);
            if (loaded instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)loaded;
                type = new ShapeType(living);
            }
        }
        return type;
    }

    public void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext registry, Commands.CommandSelection selection) {
        LiteralCommandNode rootNode = ((LiteralArgumentBuilder)Commands.m_82127_((String)"remorphed").requires(source -> source.m_6761_(2))).build();
        LiteralCommandNode removeShape = ((LiteralArgumentBuilder)Commands.m_82127_((String)"removeShape").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"shape", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)registry, (ResourceKey)Registries.f_256939_)).suggests(SuggestionProviders.f_121645_).executes(context -> {
            RemorphedCommand.removeShape((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), EntityType.m_20613_((EntityType)((EntityType)ResourceArgument.m_247713_((CommandContext)context, (String)"shape").m_203334_())), null);
            return 1;
        })).then(Commands.m_82129_((String)"nbt", (ArgumentType)CompoundTagArgument.m_87657_()).executes(context -> {
            CompoundTag nbt = CompoundTagArgument.m_87660_((CommandContext)context, (String)"nbt");
            RemorphedCommand.removeShape((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), EntityType.m_20613_((EntityType)((EntityType)ResourceArgument.m_247713_((CommandContext)context, (String)"shape").m_203334_())), nbt);
            return 1;
        }))))).build();
        LiteralCommandNode addShape = ((LiteralArgumentBuilder)Commands.m_82127_((String)"addShape").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"shape", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)registry, (ResourceKey)Registries.f_256939_)).suggests(SuggestionProviders.f_121645_).executes(context -> {
            RemorphedCommand.addShape((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), EntityType.m_20613_((EntityType)((EntityType)ResourceArgument.m_247713_((CommandContext)context, (String)"shape").m_203334_())), null);
            return 1;
        })).then(Commands.m_82129_((String)"nbt", (ArgumentType)CompoundTagArgument.m_87657_()).executes(context -> {
            CompoundTag nbt = CompoundTagArgument.m_87660_((CommandContext)context, (String)"nbt");
            RemorphedCommand.addShape((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), EntityType.m_20613_((EntityType)((EntityType)ResourceArgument.m_247713_((CommandContext)context, (String)"shape").m_203334_())), nbt);
            return 1;
        }))))).build();
        LiteralCommandNode clearShapes = ((LiteralArgumentBuilder)Commands.m_82127_((String)"clearShapes").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).executes(context -> {
            RemorphedCommand.clearShapes((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"));
            return 1;
        }))).build();
        LiteralCommandNode hasShape = ((LiteralArgumentBuilder)Commands.m_82127_((String)"hasShape").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"shape", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)registry, (ResourceKey)Registries.f_256939_)).suggests(SuggestionProviders.f_121645_).executes(context -> RemorphedCommand.hasShape((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), EntityType.m_20613_((EntityType)((EntityType)ResourceArgument.m_247713_((CommandContext)context, (String)"shape").m_203334_())), null))).then(Commands.m_82129_((String)"nbt", (ArgumentType)CompoundTagArgument.m_87657_()).executes(context -> {
            CompoundTag nbt = CompoundTagArgument.m_87660_((CommandContext)context, (String)"nbt");
            return RemorphedCommand.hasShape((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), EntityType.m_20613_((EntityType)((EntityType)ResourceArgument.m_247713_((CommandContext)context, (String)"shape").m_203334_())), nbt);
        }))))).build();
        rootNode.addChild((CommandNode)removeShape);
        rootNode.addChild((CommandNode)addShape);
        rootNode.addChild((CommandNode)clearShapes);
        rootNode.addChild((CommandNode)hasShape);
        dispatcher.getRoot().addChild((CommandNode)rootNode);
    }
}

