/*
 * Decompiled with CFR 0.152.
 */
package tocraft.remorphed.screen.widget;

import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.impl.RemorphedPlayerDataProvider;
import tocraft.remorphed.network.NetworkHandler;
import tocraft.remorphed.screen.RemorphedScreen;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.variant.ShapeType;
import tocraft.walkers.api.variant.TypeProvider;
import tocraft.walkers.api.variant.TypeProviderRegistry;
import tocraft.walkers.network.impl.SwapVariantPackets;

@OnlyIn(value=Dist.CLIENT)
public class SpecialShapeWidget
extends AbstractButton {
    private final RemorphedScreen parent;
    private final boolean isCurrent;
    private final boolean isAvailable;

    public SpecialShapeWidget(int x, int y, int width, int height, RemorphedScreen parent) {
        super(x, y, width, height, Component.m_130674_((String)""));
        LivingEntity livingEntity;
        this.parent = parent;
        CompoundTag nbt = new CompoundTag();
        if (Minecraft.m_91087_().f_91074_ != null && (livingEntity = PlayerShape.getCurrentShape((Player)Minecraft.m_91087_().f_91074_)) instanceof Wolf) {
            Wolf wolf = (Wolf)livingEntity;
            wolf.m_20240_(nbt);
        }
        this.isCurrent = nbt.m_128441_("isSpecial") && nbt.m_128471_("isSpecial");
        this.isAvailable = Remorphed.canUseEveryShape((Player)Minecraft.m_91087_().f_91074_) || ((RemorphedPlayerDataProvider)Minecraft.m_91087_().f_91074_).remorphed$getUnlockedShapes().keySet().stream().anyMatch(type -> type.getEntityType().equals(EntityType.f_20499_));
        this.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)(this.isAvailable ? "remorphed.special_shape_available" : "remorphed.special_shape_unavailable"))));
    }

    public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.m_280411_(Remorphed.id("textures/gui/wolf.png"), this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), 0.0f, 0.0f, 15, 15, 15, 15);
        if (!this.isCurrent && !this.isAvailable) {
            guiGraphics.m_280411_(Remorphed.id("textures/gui/unavailable.png"), this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), 0.0f, 0.0f, 15, 15, 15, 15);
        }
    }

    public void m_5691_() {
        if (!this.isCurrent && this.isAvailable && Walkers.hasSpecialShape((UUID)Minecraft.m_91087_().m_91094_().m_240411_())) {
            TypeProvider typeProvider = TypeProviderRegistry.getProvider((EntityType)EntityType.f_20499_);
            int range = typeProvider != null ? typeProvider.getRange() : -1;
            NetworkHandler.sendSwap2ndShapeRequest(Objects.requireNonNull(ShapeType.from((EntityType)EntityType.f_20499_, (int)-1)));
            SwapVariantPackets.sendSwapRequest((int)(range + 1));
            this.parent.m_7379_();
        }
    }

    public void m_168797_(NarrationElementOutput builder) {
    }
}

