/*
 * Decompiled with CFR 0.152.
 */
package tocraft.remorphed.screen.widget;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.network.NetworkHandler;
import tocraft.remorphed.screen.RemorphedScreen;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.variant.ShapeType;
import tocraft.walkers.traits.ShapeTrait;
import tocraft.walkers.traits.TraitRegistry;

@OnlyIn(value=Dist.CLIENT)
public class EntityWidget<T extends LivingEntity>
extends AbstractButton {
    private final ShapeType<T> type;
    private final T entity;
    private final int size;
    private final RemorphedScreen parent;
    private boolean crashed;
    private boolean isFavorite;
    private final boolean isCurrent;

    public EntityWidget(float x, float y, float width, float height, ShapeType<T> type, T entity, RemorphedScreen parent, boolean isFavorite, boolean current) {
        super((int)x, (int)y, (int)width, (int)height, Component.m_130674_((String)""));
        this.type = type;
        this.entity = entity;
        this.size = (int)(25.0f * (1.0f / Math.max(entity.m_20206_(), entity.m_20205_())));
        entity.m_146915_(true);
        this.parent = parent;
        this.isFavorite = isFavorite;
        this.isCurrent = current;
        this.m_257544_(Tooltip.m_257550_((Component)ShapeType.createTooltipText(entity)));
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean bl;
        boolean bl2 = bl = mouseX >= (double)this.m_252754_() && mouseX < (double)(this.m_252754_() + this.f_93618_) && mouseY >= (double)this.m_252907_() && mouseY < (double)(this.m_252907_() + this.f_93619_);
        if (bl && Minecraft.m_91087_().f_91074_ != null) {
            if (button == 0 && !this.type.equals((Object)ShapeType.from((LivingEntity)PlayerShape.getCurrentShape((Player)Minecraft.m_91087_().f_91074_)))) {
                NetworkHandler.sendSwap2ndShapeRequest(this.type);
                this.parent.m_7379_();
            } else if (button == 1) {
                this.isFavorite = !this.isFavorite;
                NetworkHandler.sendFavoriteRequest(this.type, this.isFavorite);
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_87963_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        if (!this.crashed) {
            if (Remorphed.displayTraitsInMenu) {
                int blitOffset = 0;
                int rowIndex = 0;
                ArrayList<ResourceLocation> renderedTraits = new ArrayList<ResourceLocation>();
                for (ShapeTrait trait : TraitRegistry.getAll(this.entity)) {
                    if (trait == null || trait.getIcon() == null || renderedTraits.contains(trait.getId()) && !trait.iconMightDiffer()) continue;
                    context.m_280159_(this.m_252754_() + rowIndex, this.m_252907_() + blitOffset, 0, 18, 18, trait.getIcon());
                    if (blitOffset >= this.m_93694_() - 18) {
                        rowIndex += 18;
                        blitOffset = 0;
                    } else {
                        blitOffset += 18;
                    }
                    if (rowIndex >= this.m_5711_() - 18) break;
                    renderedTraits.add(trait.getId());
                }
            }
            try {
                InventoryScreen.m_280432_((GuiGraphics)context, (float)((float)this.m_252754_() + (float)this.m_5711_() / 2.0f), (float)((int)((float)this.m_252907_() + (float)this.m_93694_() * 0.75f)), (int)this.size, (Vector3f)new Vector3f(), (Quaternionf)new Quaternionf().rotationXYZ(0.43633232f, (float)Math.PI, (float)Math.PI), null, this.entity);
            }
            catch (Exception e) {
                Remorphed.LOGGER.error("Error while rendering {}", (Object)ShapeType.createTooltipText(this.entity).getString(), (Object)e);
                this.crashed = true;
                MultiBufferSource.BufferSource immediate = Minecraft.m_91087_().m_91269_().m_110104_();
                immediate.m_109911_();
                EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
                entityRenderDispatcher.m_114468_(true);
                RenderSystem.getModelViewStack().m_85849_();
                Lighting.m_84931_();
            }
            if (this.isCurrent) {
                context.m_280411_(Remorphed.id("textures/gui/selected.png"), this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), 0.0f, 0.0f, 48, 32, 48, 32);
            }
            if (this.isFavorite) {
                context.m_280411_(Remorphed.id("textures/gui/favorite.png"), this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), 0.0f, 0.0f, 48, 32, 48, 32);
            }
        }
    }

    public void m_5691_() {
    }

    public void m_168797_(NarrationElementOutput builder) {
    }
}

