/*
 * Decompiled with CFR 0.152.
 */
package tocraft.remorphed.network;

import java.util.HashMap;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.client.CraftedCoreClient;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.craftedcore.network.client.ClientNetworking;
import tocraft.remorphed.impl.RemorphedPlayerDataProvider;
import tocraft.remorphed.network.NetworkHandler;
import tocraft.walkers.api.variant.ShapeType;

@OnlyIn(value=Dist.CLIENT)
public class ClientNetworking {
    public static void registerPacketHandlers() {
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.S2C, (ResourceLocation)NetworkHandler.UNLOCKED_SYNC, ClientNetworking::handleUnlockedSyncPacket);
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.S2C, (ResourceLocation)NetworkHandler.FAVORITE_SYNC, ClientNetworking::handleFavoriteSyncPacket);
    }

    public static void handleUnlockedSyncPacket(ModernNetworking.Context context, CompoundTag compound) {
        Tag tag;
        UUID uuid = compound.m_128342_("uuid");
        HashMap unlockedShapes = new HashMap();
        if (compound.m_128441_("UnlockedShapes") && (tag = compound.m_128423_("UnlockedShapes")) instanceof ListTag) {
            ListTag list = (ListTag)tag;
            list.forEach(entryTag -> {
                EntityType eType = (EntityType)BuiltInRegistries.f_256780_.m_7745_(new ResourceLocation(((CompoundTag)entryTag).m_128461_("id")));
                int variant = ((CompoundTag)entryTag).m_128451_("variant");
                int killAmount = ((CompoundTag)entryTag).m_128451_("killAmount");
                unlockedShapes.put(ShapeType.from((EntityType)eType, (int)variant), killAmount);
            });
        }
        ClientNetworking.runOrQueue(context, player -> {
            @Nullable Player syncTarget = player.m_20193_().m_46003_(uuid);
            if (syncTarget != null) {
                ((RemorphedPlayerDataProvider)syncTarget).remorphed$setUnlockedShapes(unlockedShapes);
            }
        });
    }

    private static void handleFavoriteSyncPacket(ModernNetworking.Context context, CompoundTag tag) {
        ClientNetworking.runOrQueue(context, player -> {
            RemorphedPlayerDataProvider data = (RemorphedPlayerDataProvider)player;
            data.remorphed$getFavorites().clear();
            ListTag idList = tag.m_128437_("FavoriteShapes", 10);
            idList.forEach(compound -> data.remorphed$getFavorites().add(ShapeType.from((CompoundTag)((CompoundTag)compound))));
        });
    }

    public static void runOrQueue(ModernNetworking.Context context, ClientNetworking.ApplicablePacket packet) {
        if (context.getPlayer() == null) {
            CraftedCoreClient.getSyncPacketQueue().add(packet);
        } else {
            context.queue(() -> packet.apply(context.getPlayer()));
        }
    }
}

