/*
 * Decompiled with CFR 0.152.
 */
package tocraft.remorphed;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tocraft.craftedcore.config.ConfigLoader;
import tocraft.craftedcore.event.common.CommandEvents;
import tocraft.craftedcore.event.common.EntityEvents;
import tocraft.craftedcore.event.common.PlayerEvents;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.craftedcore.platform.PlatformData;
import tocraft.craftedcore.platform.VersionChecker;
import tocraft.remorphed.RemorphedClient;
import tocraft.remorphed.command.RemorphedCommand;
import tocraft.remorphed.config.RemorphedConfig;
import tocraft.remorphed.events.ShapeEventsCallback;
import tocraft.remorphed.handler.LivingDeathHandler;
import tocraft.remorphed.handler.PlayerRespawnHandler;
import tocraft.remorphed.impl.RemorphedPlayerDataProvider;
import tocraft.remorphed.network.NetworkHandler;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.events.ShapeEvents;
import tocraft.walkers.api.variant.ShapeType;

public class Remorphed {
    public static final Logger LOGGER = LoggerFactory.getLogger(Remorphed.class);
    public static final String MODID = "remorphed";
    public static final RemorphedConfig CONFIG = (RemorphedConfig)ConfigLoader.read((String)"remorphed", RemorphedConfig.class);
    public static boolean displayVariantsInMenu = true;
    public static boolean displayTraitsInMenu = true;

    public void initialize() {
        Walkers.devs.add(UUID.fromString("74b6d9b3-c8c1-40db-ab82-ccc290d1aa03"));
        VersionChecker.registerModrinthChecker((String)MODID, (String)MODID, (Component)Component.m_237113_((String)"Remorphed"));
        if (PlatformData.getEnv() == Dist.CLIENT) {
            new RemorphedClient().initialize();
        }
        NetworkHandler.registerPacketReceiver();
        ShapeEvents.UNLOCK_SHAPE.register((player, type) -> new ShapeEventsCallback().event(player, type));
        ShapeEvents.SWAP_SHAPE.register((player, shape) -> new ShapeEventsCallback().event(player, ShapeType.from((LivingEntity)shape)));
        CommandEvents.REGISTRATION.register((Object)new RemorphedCommand());
        EntityEvents.LIVING_DEATH.register((Object)new LivingDeathHandler());
        PlayerEvents.PLAYER_RESPAWN.register((Object)new PlayerRespawnHandler());
        Walkers.CONFIG.unlockOverridesCurrentShape = Remorphed.CONFIG.unlockFriendlyNormal;
        Walkers.CONFIG.save();
        PlayerEvents.PLAYER_JOIN.register(NetworkHandler::sendFavoriteSync);
    }

    public static boolean canUseEveryShape(Player player) {
        return player.m_7500_() && Remorphed.CONFIG.creativeUnlockAll;
    }

    public static boolean canUseShape(Player player, ShapeType<?> type) {
        return Remorphed.canUseEveryShape(player) || !Remorphed.CONFIG.lockTransform && (type == null || Remorphed.getKillToUnlock(type.getEntityType()) <= 0 || ((RemorphedPlayerDataProvider)player).remorphed$getKills(type) >= Remorphed.getKillToUnlock(type.getEntityType()));
    }

    public static List<ShapeType<?>> getUnlockedShapes(Player player) {
        if (Remorphed.canUseEveryShape(player)) {
            return ShapeType.getAllTypes((Level)player.m_9236_());
        }
        if (Walkers.CONFIG.unlockEveryVariant) {
            ArrayList unlocked = new ArrayList();
            for (ShapeType shapeType : ShapeType.getAllTypes((Level)player.m_9236_())) {
                if (unlocked.contains(shapeType) || !Remorphed.canUseShape(player, shapeType)) continue;
                unlocked.add(shapeType);
            }
            return unlocked;
        }
        return new ArrayList(((RemorphedPlayerDataProvider)player).remorphed$getUnlockedShapes().keySet().stream().filter(type -> Remorphed.canUseShape(player, type)).toList());
    }

    public static int getKillToUnlock(EntityType<?> entityType) {
        String id = BuiltInRegistries.f_256780_.m_7981_(entityType).toString();
        if (Remorphed.CONFIG.killToUnlockByType.containsKey(id)) {
            return Remorphed.CONFIG.killToUnlockByType.get(id);
        }
        return Remorphed.CONFIG.killToUnlock;
    }

    public static void sync(ServerPlayer player) {
        Remorphed.sync(player, player);
    }

    public static void sync(ServerPlayer changed, ServerPlayer packetTarget) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        CompoundTag compoundTag = new CompoundTag();
        Map<ShapeType<? extends LivingEntity>, Integer> unlockedShapes = ((RemorphedPlayerDataProvider)changed).remorphed$getUnlockedShapes();
        ListTag list = new ListTag();
        unlockedShapes.forEach((shape, killAmount) -> {
            if (killAmount > 0 && shape != null) {
                CompoundTag compound = new CompoundTag();
                compound.m_128359_("id", BuiltInRegistries.f_256780_.m_7981_((Object)shape.getEntityType()).toString());
                compound.m_128405_("variant", shape.getVariantData());
                compound.m_128405_("killAmount", killAmount.intValue());
                list.add((Object)compound);
            }
        });
        if (!unlockedShapes.isEmpty()) {
            compoundTag.m_128365_("UnlockedShapes", (Tag)list);
        }
        compoundTag.m_128362_("uuid", changed.m_20148_());
        ModernNetworking.sendToPlayer((ServerPlayer)packetTarget, (ResourceLocation)NetworkHandler.UNLOCKED_SYNC, (CompoundTag)compoundTag);
    }

    public static ResourceLocation id(String name) {
        return new ResourceLocation(MODID, name);
    }
}

