package tocraft.remorphed.screen.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import tocraft.remorphed.screen.RemorphedScreen;
import tocraft.walkers.impl.PlayerDataProvider;
import tocraft.walkers.network.impl.SwapPackets;

@Environment(EnvType.CLIENT)
public class PlayerWidget extends AbstractButton {
    private final RemorphedScreen parent;

    public PlayerWidget(int x, int y, int width, int height, RemorphedScreen parent) {
        super(x, y, width, height, Component.m_130674_(""));
        this.parent = parent;
        m_257544_(Tooltip.m_257550_(Component.m_237115_("remorphed.player_icon")));
    }

    @Override
    public void m_87963_(PoseStack guiGraphics, int mouseX, int mouseY, float delta) {
        if (Minecraft.m_91087_().f_91074_ != null) {
            ResourceLocation skinLocation = Minecraft.m_91087_().f_91074_.m_108560_();
            RenderSystem.m_157456_(0, skinLocation);
            GuiComponent.m_93160_(guiGraphics, m_252754_(), m_252907_(), m_5711_(), m_93694_(), 8.0f, 8, 8, 8, 64, 64);
            GuiComponent.m_93160_(guiGraphics, m_252754_(), m_252907_(), m_5711_(), m_93694_(), 40.0f, 8, 8, 8, 64, 64);
        } else
            super.m_87963_(guiGraphics, mouseX, mouseY, delta);
    }

    @Override
    public void m_5691_() {
        if (Minecraft.m_91087_().f_91074_ != null && ((PlayerDataProvider) Minecraft.m_91087_().f_91074_).walkers$getCurrentShape() != null) {
            SwapPackets.sendSwapRequest();
            parent.m_7379_();
        }
    }

    @Override
    public void m_168797_(NarrationElementOutput builder) {

    }
}
