package tocraft.remorphed.mixin;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.remorphed.impl.RemorphedPlayerDataProvider;

@Environment(EnvType.CLIENT)
@Mixin(ClientPacketListener.class)
public abstract class ClientPlayerDataCacheMixin {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Unique
    private RemorphedPlayerDataProvider remorphed$dataCache = null;

    // This @Inject caches the custom data attached to this client's player before it
    // is reset when changing dimensions.
    // For example, switching from The End => Overworld will reset the player's NBT.
    @Inject(method = "handleRespawn", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;createPlayer(Lnet/minecraft/client/multiplayer/ClientLevel;Lnet/minecraft/stats/StatsCounter;Lnet/minecraft/client/ClientRecipeBook;ZZ)Lnet/minecraft/client/player/LocalPlayer;"))
    private void beforePlayerReset(ClientboundRespawnPacket packet, CallbackInfo ci) {
        remorphed$dataCache = ((RemorphedPlayerDataProvider) minecraft.f_91074_);
    }

    // This inject applies data cached from the previous inject.
    // Re-applying on the client will help to prevent sync blips which occur when
    // wiping data and waiting for the server to send a sync packet.
    @Inject(method = "handleRespawn", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/Level;dimension()Lnet/minecraft/resources/ResourceKey;", ordinal = 1))
    private void afterPlayerReset(ClientboundRespawnPacket packet, CallbackInfo ci) {
        if (remorphed$dataCache != null && minecraft.f_91074_ != null) {
            ((RemorphedPlayerDataProvider) minecraft.f_91074_).remorphed$setUnlockedShapes(remorphed$dataCache.remorphed$getUnlockedShapes());
            ((RemorphedPlayerDataProvider) minecraft.f_91074_).remorphed$getFavorites().clear();
            ((RemorphedPlayerDataProvider) minecraft.f_91074_).remorphed$getFavorites().addAll(remorphed$dataCache.remorphed$getFavorites());
        }

        remorphed$dataCache = null;
    }
}