/*
 * Decompiled with CFR 0.152.
 */
package tocraft.remorphed.screen;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.impl.RemorphedPlayerDataProvider;
import tocraft.remorphed.mixin.accessor.ScreenAccessor;
import tocraft.remorphed.screen.RemorphedHelpScreen;
import tocraft.remorphed.screen.widget.EntityWidget;
import tocraft.remorphed.screen.widget.PlayerWidget;
import tocraft.remorphed.screen.widget.SearchWidget;
import tocraft.remorphed.screen.widget.SpecialShapeWidget;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.variant.ShapeType;

@OnlyIn(value=Dist.CLIENT)
public class RemorphedScreen
extends Screen {
    private final List<ShapeType<?>> unlocked = new CopyOnWriteArrayList();
    private final Map<ShapeType<?>, Mob> renderEntities = new LinkedHashMap();
    private final List<EntityWidget<?>> entityWidgets = new CopyOnWriteArrayList();
    private final SearchWidget searchBar = this.createSearchBar();
    private final Button helpButton = this.createHelpButton();
    private final Button variantsButton = this.createVariantsButton();
    private final Button skillsButton = this.createSkillsButton();
    private final PlayerWidget playerButton = this.createPlayerButton();
    private final SpecialShapeWidget specialShapeButton = this.createSpecialShapeButton();
    private String lastSearchContents = "";

    public RemorphedScreen() {
        super((Component)Component.m_237113_((String)""));
        super.m_6575_(Minecraft.m_91087_(), Minecraft.m_91087_().m_91268_().m_85445_(), Minecraft.m_91087_().m_91268_().m_85446_());
    }

    public void m_7856_() {
        if (this.f_96541_ == null) {
            return;
        }
        if (this.f_96541_.f_91074_ == null) {
            this.m_7379_();
            return;
        }
        this.m_142416_((GuiEventListener)this.searchBar);
        this.m_142416_((GuiEventListener)this.helpButton);
        this.m_142416_((GuiEventListener)this.variantsButton);
        this.m_142416_((GuiEventListener)this.skillsButton);
        this.m_142416_((GuiEventListener)this.playerButton);
        if (Walkers.hasSpecialShape((UUID)this.f_96541_.f_91074_.m_20148_())) {
            this.m_142416_((GuiEventListener)this.specialShapeButton);
        }
        new Thread(() -> {
            this.populateUnlockedRenderEntities((Player)this.f_96541_.f_91074_);
            ShapeType currentShape = ShapeType.from((LivingEntity)PlayerShape.getCurrentShape((Player)this.f_96541_.f_91074_));
            this.unlocked.sort((first, second) -> {
                boolean secondIsFav;
                if (Objects.equals(first, currentShape)) {
                    return -1;
                }
                if (Objects.equals(second, currentShape)) {
                    return 1;
                }
                boolean firstIsFav = ((RemorphedPlayerDataProvider)this.f_96541_.f_91074_).remorphed$getFavorites().contains(first);
                if (firstIsFav == (secondIsFav = ((RemorphedPlayerDataProvider)this.f_96541_.f_91074_).remorphed$getFavorites().contains(second))) {
                    return 0;
                }
                if (firstIsFav) {
                    return -1;
                }
                return 1;
            });
            if (!Remorphed.displayVariantsInMenu) {
                ArrayList newUnlocked = new ArrayList();
                for (ShapeType<?> shapeType : this.unlocked) {
                    if (!shapeType.equals((Object)currentShape) && newUnlocked.stream().map(ShapeType::getEntityType).toList().contains(shapeType.getEntityType())) continue;
                    newUnlocked.add(shapeType);
                }
                this.unlocked.clear();
                this.unlocked.addAll(newUnlocked);
            }
            this.populateEntityWidgets(this.unlocked);
        }, "cache entities").start();
        this.searchBar.m_94151_(text -> {
            this.m_94725_((GuiEventListener)this.searchBar);
            if (!this.lastSearchContents.equals(text)) {
                ((ScreenAccessor)((Object)this)).getSelectables().removeIf(button -> button instanceof EntityWidget);
                this.m_6702_().removeIf(button -> button instanceof EntityWidget);
                List<ShapeType<?>> filtered = this.unlocked.stream().filter(type -> text.isEmpty() || ShapeType.createTooltipText((LivingEntity)this.renderEntities.get(type)).getString().toUpperCase().contains(text.toUpperCase()) || EntityType.m_20613_((EntityType)type.getEntityType()).toString().toUpperCase().contains(text.toUpperCase())).collect(Collectors.toList());
                this.populateEntityWidgets(filtered);
            }
            this.lastSearchContents = text;
        });
    }

    public void m_86412_(PoseStack context, int mouseX, int mouseY, float delta) {
        this.m_7333_(context);
        this.searchBar.m_86412_(context, mouseX, mouseY, delta);
        this.helpButton.m_86412_(context, mouseX, mouseY, delta);
        this.variantsButton.m_86412_(context, mouseX, mouseY, delta);
        this.skillsButton.m_86412_(context, mouseX, mouseY, delta);
        this.playerButton.m_86412_(context, mouseX, mouseY, delta);
        if (Walkers.hasSpecialShape((UUID)this.f_96541_.f_91074_.m_20148_())) {
            this.specialShapeButton.m_86412_(context, mouseX, mouseY, delta);
        }
        double scaledFactor = this.f_96541_.m_91268_().m_85449_();
        int top = 35;
        context.m_85836_();
        RenderSystem.m_69488_((int)((int)(0.0 * scaledFactor)), (int)((int)(0.0 * scaledFactor)), (int)((int)((double)this.f_96543_ * scaledFactor)), (int)((int)((double)(this.f_96544_ - top) * scaledFactor)));
        for (EntityWidget<?> widget : this.entityWidgets) {
            if (widget.m_252907_() + widget.m_93694_() <= top || widget.m_252907_() >= this.getWindow().m_85446_()) continue;
            widget.m_86412_(context, mouseX, mouseY, delta);
        }
        RenderSystem.m_69471_();
        context.m_85849_();
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollY) {
        if (!this.entityWidgets.isEmpty()) {
            float firstPos = this.entityWidgets.get(0).m_252907_();
            EntityWidget<?> lastWidget = this.entityWidgets.get(this.entityWidgets.size() - 1);
            if (scrollY >= 0.0 && firstPos >= 35.0f || scrollY <= 0.0 && lastWidget.m_252907_() <= this.getWindow().m_85446_() - lastWidget.m_93694_()) {
                return false;
            }
            for (NarratableEntry button : ((ScreenAccessor)((Object)this)).getSelectables()) {
                if (!(button instanceof EntityWidget)) continue;
                EntityWidget widget = (EntityWidget)button;
                widget.m_264152_(widget.m_252754_(), (int)((double)widget.m_252907_() + scrollY * 10.0));
            }
        }
        return false;
    }

    private synchronized void populateEntityWidgets(List<ShapeType<?>> rendered) {
        this.entityWidgets.clear();
        int x = 15;
        int y = 35;
        int rows = (int)Math.ceil((float)rendered.size() / 7.0f);
        ShapeType currentType = ShapeType.from((LivingEntity)PlayerShape.getCurrentShape((Player)this.f_96541_.f_91074_));
        for (int yIndex = 0; yIndex <= rows; ++yIndex) {
            for (int xIndex = 0; xIndex < 7; ++xIndex) {
                int listIndex = yIndex * 7 + xIndex;
                if (listIndex >= rendered.size()) continue;
                ShapeType<?> type = rendered.get(listIndex);
                Mob entity = this.renderEntities.get(type);
                if (entity != null) {
                    EntityWidget<Mob> entityWidget = new EntityWidget<Mob>((float)(this.getWindow().m_85445_() - 27) / 7.0f * (float)xIndex + (float)x, (float)this.getWindow().m_85446_() / 5.0f * (float)yIndex + (float)y, (float)(this.getWindow().m_85445_() - 27) / 7.0f, (float)this.getWindow().m_85446_() / 5.0f, type, entity, this, ((RemorphedPlayerDataProvider)this.f_96541_.f_91074_).remorphed$getFavorites().contains(type), type.equals((Object)currentType));
                    this.m_142416_((GuiEventListener)entityWidget);
                    this.entityWidgets.add(entityWidget);
                    continue;
                }
                Remorphed.LOGGER.error("invalid shape type: " + type.getEntityType().m_20675_());
            }
        }
    }

    public synchronized void populateUnlockedRenderEntities(Player player) {
        this.unlocked.clear();
        this.renderEntities.clear();
        List<ShapeType<?>> validUnlocked = Remorphed.getUnlockedShapes(player);
        for (ShapeType<?> type : validUnlocked) {
            LivingEntity entity = type.create((Level)Minecraft.m_91087_().f_91073_);
            if (!(entity instanceof Mob)) continue;
            Mob living = (Mob)entity;
            this.unlocked.add(type);
            this.renderEntities.put(type, living);
        }
        Remorphed.LOGGER.info(String.format("Loaded %d entities for rendering", this.unlocked.size()));
    }

    private SearchWidget createSearchBar() {
        return new SearchWidget((float)this.getWindow().m_85445_() / 2.0f - (float)this.getWindow().m_85445_() / 4.0f / 2.0f - 5.0f, 5.0f, (float)this.getWindow().m_85445_() / 4.0f, 20.0f);
    }

    private Button createHelpButton() {
        Button.Builder helpButton = Button.m_253074_((Component)Component.m_130674_((String)"?"), widget -> Minecraft.m_91087_().m_91152_((Screen)new RemorphedHelpScreen()));
        int xOffset = Walkers.hasSpecialShape((UUID)Minecraft.m_91087_().f_91074_.m_20148_()) ? 30 : 0;
        helpButton.m_252794_((int)((float)this.getWindow().m_85445_() / 2.0f + (float)this.getWindow().m_85445_() / 8.0f + 35.0f + (float)xOffset), 5);
        helpButton.m_253046_(20, 20);
        helpButton.m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"remorphed.help")));
        return helpButton.m_253136_();
    }

    private Button createVariantsButton() {
        Button.Builder variantsButton = Button.m_253074_((Component)Component.m_237115_((String)"remorphed.display_variants"), widget -> {
            Remorphed.displayVariantsInMenu = !Remorphed.displayVariantsInMenu;
            Minecraft.m_91087_().m_91152_((Screen)new RemorphedScreen());
        });
        variantsButton.m_252794_((int)((float)this.getWindow().m_85445_() / 2.0f - (float)this.getWindow().m_85445_() / 4.0f / 2.0f - 110.0f), 5);
        variantsButton.m_253046_(100, 20);
        variantsButton.m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"remorphed.variants")));
        return variantsButton.m_253136_();
    }

    private Button createSkillsButton() {
        Button.Builder skillButton = Button.m_253074_((Component)Component.m_237115_((String)"remorphed.show_skills"), widget -> {
            Remorphed.displaySkillsInMenu = !Remorphed.displaySkillsInMenu;
        });
        int xOffset = Walkers.hasSpecialShape((UUID)Minecraft.m_91087_().f_91074_.m_20148_()) ? 30 : 0;
        int xPos = (int)((float)this.getWindow().m_85445_() / 2.0f + (float)this.getWindow().m_85445_() / 8.0f + 65.0f + (float)xOffset);
        skillButton.m_252794_(xPos, 5);
        skillButton.m_253046_(Math.min(50, this.getWindow().m_85445_() - xPos), 20);
        skillButton.m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"remorphed.skills")));
        return skillButton.m_253136_();
    }

    private PlayerWidget createPlayerButton() {
        return new PlayerWidget((int)((float)this.getWindow().m_85445_() / 2.0f + (float)this.getWindow().m_85445_() / 8.0f + 5.0f), 5, 20, 20, this);
    }

    private SpecialShapeWidget createSpecialShapeButton() {
        return new SpecialShapeWidget((int)((float)this.getWindow().m_85445_() / 2.0f + (float)this.getWindow().m_85445_() / 8.0f + 35.0f), 5, 20, 20, this);
    }

    private Window getWindow() {
        return Minecraft.m_91087_().m_91268_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (mouseY < 35.0) {
            return this.searchBar.m_6375_(mouseX, mouseY, button) || this.helpButton.m_6375_(mouseX, mouseY, button) || this.variantsButton.m_6375_(mouseX, mouseY, button) || this.skillsButton.m_6375_(mouseX, mouseY, button) || this.playerButton.m_6375_(mouseX, mouseY, button) || this.specialShapeButton.m_6375_(mouseX, mouseY, button);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }
}

