/*
 * Decompiled with CFR 0.152.
 */
package tocraft.remorphed.network;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.impl.RemorphedPlayerDataProvider;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.PlayerShapeChanger;
import tocraft.walkers.api.variant.ShapeType;

public class NetworkHandler {
    public static final ResourceLocation SHAPE_REQUEST = Remorphed.id("unlock_request");
    public static final ResourceLocation UNLOCKED_SYNC = Remorphed.id("unlocked_sync");
    public static final ResourceLocation FAVORITE_SYNC = Remorphed.id("favorite_sync");
    public static final ResourceLocation FAVORITE_UPDATE = Remorphed.id("favorite_update");

    public static void registerPacketReceiver() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)SHAPE_REQUEST, NetworkHandler::handleShapeRequestPacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)FAVORITE_UPDATE, NetworkHandler::handleFavoriteRequestPacket);
    }

    public static <T extends LivingEntity> void sendSwap2ndShapeRequest(@NotNull ShapeType<T> type) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("id", BuiltInRegistries.f_256780_.m_7981_((Object)type.getEntityType()).toString());
        compound.m_128405_("variant", type.getVariantData());
        buf.m_130079_(compound);
        NetworkManager.sendToServer((ResourceLocation)SHAPE_REQUEST, (FriendlyByteBuf)buf);
    }

    private static void handleShapeRequestPacket(FriendlyByteBuf packet, NetworkManager.PacketContext context) {
        CompoundTag compound = packet.m_130260_();
        context.getPlayer().m_20194_().execute(() -> {
            if (Walkers.CONFIG.playerUUIDBlacklist.contains(context.getPlayer().m_20148_())) {
                context.getPlayer().m_5661_((Component)Component.m_237115_((String)"walkers.player_blacklisted"), true);
                return;
            }
            ResourceLocation typeId = new ResourceLocation(compound.m_128461_("id"));
            int typeVariant = compound.m_128451_("variant");
            EntityType eType = (EntityType)BuiltInRegistries.f_256780_.m_7745_(typeId);
            @Nullable ShapeType type = ShapeType.from((EntityType)eType, (int)typeVariant);
            boolean result = PlayerShapeChanger.change2ndShape((ServerPlayer)((ServerPlayer)context.getPlayer()), (ShapeType)type);
            if (result && type != null) {
                PlayerShape.updateShapes((ServerPlayer)((ServerPlayer)context.getPlayer()), (LivingEntity)type.create(context.getPlayer().f_19853_));
            }
            context.getPlayer().m_6210_();
        });
    }

    public static void sendFavoriteSync(ServerPlayer player) {
        Set<ShapeType<?>> favorites = ((RemorphedPlayerDataProvider)player).remorphed$getFavorites();
        CompoundTag tag = new CompoundTag();
        ListTag idList = new ListTag();
        favorites.forEach(type -> idList.add((Object)type.writeCompound()));
        tag.m_128365_("FavoriteShapes", (Tag)idList);
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.m_130079_(tag);
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)FAVORITE_SYNC, (FriendlyByteBuf)packet);
    }

    public static void sendFavoriteRequest(ShapeType<? extends LivingEntity> type, boolean favorite) {
        FriendlyByteBuf packet = new FriendlyByteBuf(Unpooled.buffer());
        packet.m_130085_(BuiltInRegistries.f_256780_.m_7981_((Object)type.getEntityType()));
        packet.writeInt(type.getVariantData());
        packet.writeBoolean(favorite);
        NetworkManager.sendToServer((ResourceLocation)FAVORITE_UPDATE, (FriendlyByteBuf)packet);
    }

    private static void handleFavoriteRequestPacket(FriendlyByteBuf packet, NetworkManager.PacketContext context) {
        EntityType entityType = (EntityType)BuiltInRegistries.f_256780_.m_7745_(packet.m_130281_());
        int variant = packet.readInt();
        boolean favorite = packet.readBoolean();
        RemorphedPlayerDataProvider playerData = (RemorphedPlayerDataProvider)context.getPlayer();
        context.getPlayer().m_20194_().execute(() -> {
            @Nullable ShapeType type = ShapeType.from((EntityType)entityType, (int)variant);
            if (type != null) {
                if (favorite) {
                    playerData.remorphed$getFavorites().add(type);
                } else {
                    playerData.remorphed$getFavorites().remove(type);
                }
                NetworkHandler.sendFavoriteSync((ServerPlayer)context.getPlayer());
            }
        });
    }
}

