/*
 * Decompiled with CFR 0.152.
 */
package tocraft.remorphed.network;

import dev.architectury.networking.NetworkManager;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.client.CraftedCoreClient;
import tocraft.craftedcore.network.client.ClientNetworking;
import tocraft.remorphed.impl.RemorphedPlayerDataProvider;
import tocraft.remorphed.network.NetworkHandler;
import tocraft.walkers.api.variant.ShapeType;

@OnlyIn(value=Dist.CLIENT)
public class ClientNetworking {
    public static void registerPacketHandlers() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)NetworkHandler.UNLOCKED_SYNC, ClientNetworking::handleUnlockedSyncPacket);
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)NetworkHandler.FAVORITE_SYNC, ClientNetworking::handleFavoriteSyncPacket);
    }

    public static void handleUnlockedSyncPacket(FriendlyByteBuf packet, NetworkManager.PacketContext context) {
        Tag tag;
        UUID uuid = packet.m_130259_();
        CompoundTag compound = packet.m_130260_();
        HashMap unlockedShapes = new HashMap();
        if (compound != null && compound.m_128441_("UnlockedShapes") && (tag = compound.m_128423_("UnlockedShapes")) instanceof ListTag) {
            ListTag list = (ListTag)tag;
            list.forEach(entryTag -> {
                EntityType eType = (EntityType)BuiltInRegistries.f_256780_.m_7745_(new ResourceLocation(((CompoundTag)entryTag).m_128461_("id")));
                int variant = ((CompoundTag)entryTag).m_128451_("variant");
                int killAmount = ((CompoundTag)entryTag).m_128451_("killAmount");
                unlockedShapes.put(ShapeType.from((EntityType)eType, (int)variant), killAmount);
            });
        }
        ClientNetworking.runOrQueue(context, player -> {
            @Nullable Player syncTarget = player.m_20193_().m_46003_(uuid);
            if (syncTarget != null) {
                ((RemorphedPlayerDataProvider)syncTarget).remorphed$setUnlockedShapes(unlockedShapes);
            }
        });
    }

    private static void handleFavoriteSyncPacket(FriendlyByteBuf packet, NetworkManager.PacketContext context) {
        CompoundTag tag = packet.m_130260_();
        if (tag != null) {
            ClientNetworking.runOrQueue(context, player -> {
                RemorphedPlayerDataProvider data = (RemorphedPlayerDataProvider)player;
                data.remorphed$getFavorites().clear();
                ListTag idList = tag.m_128437_("FavoriteShapes", 10);
                idList.forEach(compound -> data.remorphed$getFavorites().add(ShapeType.from((CompoundTag)((CompoundTag)compound))));
            });
        }
    }

    public static void runOrQueue(NetworkManager.PacketContext context, ClientNetworking.ApplicablePacket packet) {
        if (context.getPlayer() == null) {
            CraftedCoreClient.getSyncPacketQueue().add(packet);
        } else {
            context.queue(() -> packet.apply(context.getPlayer()));
        }
    }
}

