/*
 * Decompiled with CFR 0.152.
 */
package tocraft.remorphed.mixin;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.impl.RemorphedPlayerDataProvider;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.PlayerShapeChanger;
import tocraft.walkers.api.variant.ShapeType;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    private LivingEntityMixin(EntityType<? extends LivingEntity> type, Level world) {
        super(type, world);
    }

    @Inject(method={"die"}, at={@At(value="HEAD")})
    public void onDeath(DamageSource damageSource, CallbackInfo ci) {
        Entity entity;
        if (!(this instanceof Player) && (entity = damageSource.m_7639_()) instanceof ServerPlayer) {
            ServerPlayer killer = (ServerPlayer)entity;
            ShapeType type = ShapeType.from((LivingEntity)((LivingEntity)this));
            if (type != null) {
                ((RemorphedPlayerDataProvider)killer).remorphed$addKill((ShapeType<? extends LivingEntity>)type);
                if (Remorphed.CONFIG.autoTransform && ((RemorphedPlayerDataProvider)killer).remorphed$getKills((ShapeType<? extends LivingEntity>)type) >= Remorphed.getKillToUnlock(type.getEntityType())) {
                    PlayerShapeChanger.change2ndShape((ServerPlayer)killer, (ShapeType)type);
                    PlayerShape.updateShapes((ServerPlayer)killer, (LivingEntity)type.create(killer.f_19853_));
                }
            }
        }
    }
}

