/*
 * Decompiled with CFR 0.152.
 */
package tocraft.remorphed.screen.widget;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.network.NetworkHandler;
import tocraft.remorphed.screen.RemorphedScreen;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.variant.ShapeType;
import tocraft.walkers.traits.ShapeTrait;
import tocraft.walkers.traits.TraitRegistry;

@OnlyIn(value=Dist.CLIENT)
public class EntityWidget<T extends LivingEntity>
extends AbstractButton {
    private final ShapeType<T> type;
    private final T entity;
    private final int size;
    private final RemorphedScreen parent;
    private boolean crashed;
    private boolean isFavorite;
    private final boolean isCurrent;

    public EntityWidget(float x, float y, float width, float height, ShapeType<T> type, T entity, RemorphedScreen parent, boolean isFavorite, boolean current) {
        super((int)x, (int)y, (int)width, (int)height, Component.m_130674_((String)""));
        this.type = type;
        this.entity = entity;
        this.size = (int)(25.0f * (1.0f / Math.max(entity.m_20206_(), entity.m_20205_())));
        entity.m_146915_(true);
        this.parent = parent;
        this.isFavorite = isFavorite;
        this.isCurrent = current;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean bl;
        boolean bl2 = bl = mouseX >= (double)this.f_93620_ && mouseX < (double)(this.f_93620_ + this.f_93618_) && mouseY >= (double)this.f_93621_ && mouseY < (double)(this.f_93621_ + this.f_93619_);
        if (bl && Minecraft.m_91087_().f_91074_ != null) {
            if (button == 0 && !this.type.equals((Object)ShapeType.from((LivingEntity)PlayerShape.getCurrentShape((Player)Minecraft.m_91087_().f_91074_)))) {
                NetworkHandler.sendSwap2ndShapeRequest(this.type);
                this.parent.m_7379_();
            } else if (button == 1) {
                this.isFavorite = !this.isFavorite;
                NetworkHandler.sendFavoriteRequest(this.type, this.isFavorite);
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_6303_(PoseStack context, int mouseX, int mouseY, float delta) {
        if (!this.crashed) {
            if (Remorphed.displayTraitsInMenu) {
                int blitOffset = 0;
                int rowIndex = 0;
                ArrayList<ResourceLocation> renderedTraits = new ArrayList<ResourceLocation>();
                for (ShapeTrait trait : TraitRegistry.getAll(this.entity)) {
                    if (trait == null || trait.getIcon() == null || renderedTraits.contains(trait.getId()) && !trait.iconMightDiffer()) continue;
                    RenderSystem.m_157456_((int)0, (ResourceLocation)trait.getIcon().m_118414_().m_118330_());
                    GuiComponent.m_93200_((PoseStack)context, (int)(this.f_93620_ + rowIndex), (int)(this.f_93621_ + blitOffset), (int)0, (int)18, (int)18, (TextureAtlasSprite)trait.getIcon());
                    if (blitOffset >= this.m_93694_() - 18) {
                        rowIndex += 18;
                        blitOffset = 0;
                    } else {
                        blitOffset += 18;
                    }
                    if (rowIndex >= this.m_5711_() - 18) break;
                    renderedTraits.add(trait.getId());
                }
            }
            try {
                InventoryScreen.m_98850_((int)(this.f_93620_ + this.m_5711_() / 2), (int)((int)((float)this.f_93621_ + (float)this.m_93694_() * 0.75f)), (int)this.size, (float)-10.0f, (float)-10.0f, this.entity);
            }
            catch (Exception e) {
                Remorphed.LOGGER.error("Error while rendering {}", (Object)ShapeType.createTooltipText(this.entity).getString(), (Object)e);
                this.crashed = true;
                MultiBufferSource.BufferSource immediate = Minecraft.m_91087_().m_91269_().m_110104_();
                immediate.m_109911_();
                EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
                entityRenderDispatcher.m_114468_(true);
                RenderSystem.m_157191_().m_85849_();
                Lighting.m_84931_();
            }
            if (this.isCurrent) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)Remorphed.id("textures/gui/selected.png"));
                GuiComponent.m_93160_((PoseStack)context, (int)this.f_93620_, (int)this.f_93621_, (int)this.m_5711_(), (int)this.m_93694_(), (float)0.0f, (float)0.0f, (int)48, (int)32, (int)48, (int)32);
            }
            if (this.isFavorite) {
                RenderSystem.m_157456_((int)0, (ResourceLocation)Remorphed.id("textures/gui/favorite.png"));
                GuiComponent.m_93160_((PoseStack)context, (int)this.f_93620_, (int)this.f_93621_, (int)this.m_5711_(), (int)this.m_93694_(), (float)0.0f, (float)0.0f, (int)48, (int)32, (int)48, (int)32);
            }
        }
        if (this.m_198029_()) {
            this.m_7428_(context, mouseX, mouseY);
        }
    }

    public void m_7428_(PoseStack poseStack, int mouseX, int mouseY) {
        Screen currentScreen = Minecraft.m_91087_().f_91080_;
        if (currentScreen != null) {
            currentScreen.m_96602_(poseStack, ShapeType.createTooltipText(this.entity), mouseX, mouseY);
        }
    }

    public void m_5691_() {
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }
}

