/*
 * Decompiled with CFR 0.152.
 */
package tocraft.remorphed.network;

import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.impl.PlayerMorph;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.PlayerShapeChanger;
import tocraft.walkers.api.variant.ShapeType;

public class NetworkHandler {
    public static final ResourceLocation SHAPE_REQUEST = Remorphed.id("unlock_request");
    public static final ResourceLocation UNLOCKED_SYNC = Remorphed.id("unlocked_sync");
    public static final ResourceLocation FAVORITE_SYNC = Remorphed.id("favorite_sync");
    public static final ResourceLocation FAVORITE_UPDATE = Remorphed.id("favorite_update");

    public static void registerPacketReceiver() {
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.C2S, (ResourceLocation)SHAPE_REQUEST, NetworkHandler::handleShapeRequestPacket);
        ModernNetworking.registerReceiver((ModernNetworking.Side)ModernNetworking.Side.C2S, (ResourceLocation)FAVORITE_UPDATE, NetworkHandler::handleFavoriteRequestPacket);
    }

    public static <T extends LivingEntity> void sendSwap2ndShapeRequest(@NotNull ShapeType<T> type) {
        CompoundTag compound = new CompoundTag();
        compound.m_128359_("id", Registry.f_122826_.m_7981_((Object)type.getEntityType()).toString());
        compound.m_128405_("variant", type.getVariantData());
        ModernNetworking.sendToServer((ResourceLocation)SHAPE_REQUEST, (CompoundTag)compound);
    }

    private static void handleShapeRequestPacket(ModernNetworking.Context context, CompoundTag compound) {
        context.getPlayer().m_20194_().execute(() -> {
            if (Walkers.CONFIG.playerUUIDBlacklist.contains(context.getPlayer().m_142081_())) {
                context.getPlayer().m_5661_((Component)new TranslatableComponent("walkers.player_blacklisted"), true);
                return;
            }
            ResourceLocation typeId = new ResourceLocation(compound.m_128461_("id"));
            int typeVariant = compound.m_128451_("variant");
            EntityType eType = (EntityType)Registry.f_122826_.m_7745_(typeId);
            @Nullable ShapeType type = ShapeType.from((EntityType)eType, (int)typeVariant);
            boolean result = PlayerShapeChanger.change2ndShape((ServerPlayer)((ServerPlayer)context.getPlayer()), (ShapeType)type);
            if (result && type != null) {
                PlayerShape.updateShapes((ServerPlayer)((ServerPlayer)context.getPlayer()), (LivingEntity)type.create(context.getPlayer().f_19853_));
            }
            context.getPlayer().m_6210_();
        });
    }

    public static void sendFavoriteSync(ServerPlayer player) {
        Set<ShapeType<?>> favorites = PlayerMorph.getFavorites((Player)player);
        CompoundTag tag = new CompoundTag();
        ListTag idList = new ListTag();
        favorites.forEach(type -> idList.add((Object)type.writeCompound()));
        tag.m_128365_("FavoriteShapes", (Tag)idList);
        ModernNetworking.sendToPlayer((ServerPlayer)player, (ResourceLocation)FAVORITE_SYNC, (CompoundTag)tag);
    }

    public static void sendFavoriteRequest(ShapeType<? extends LivingEntity> type, boolean favorite) {
        CompoundTag packet = new CompoundTag();
        packet.m_128359_("id", Registry.f_122826_.m_7981_((Object)type.getEntityType()).toString());
        packet.m_128405_("variant", type.getVariantData());
        packet.m_128379_("favorite", favorite);
        ModernNetworking.sendToServer((ResourceLocation)FAVORITE_UPDATE, (CompoundTag)packet);
    }

    private static void handleFavoriteRequestPacket(ModernNetworking.Context context, CompoundTag packet) {
        EntityType entityType = (EntityType)Registry.f_122826_.m_7745_(new ResourceLocation(packet.m_128461_("id")));
        int variant = packet.m_128451_("variant");
        boolean favorite = packet.m_128471_("favorite");
        context.getPlayer().m_20194_().execute(() -> {
            @Nullable ShapeType type = ShapeType.from((EntityType)entityType, (int)variant);
            if (type != null) {
                if (favorite) {
                    PlayerMorph.getFavorites(context.getPlayer()).add(type);
                } else {
                    PlayerMorph.getFavorites(context.getPlayer()).remove(type);
                }
                NetworkHandler.sendFavoriteSync((ServerPlayer)context.getPlayer());
            }
        });
    }
}

