/*
 * Decompiled with CFR 0.152.
 */
package tocraft.remorphed.mixin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.impl.RemorphedPlayerDataProvider;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.variant.ShapeType;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
extends LivingEntity
implements RemorphedPlayerDataProvider {
    @Unique
    private final Map<ShapeType<? extends LivingEntity>, Integer> remorphed$unlockedShapes = new HashMap<ShapeType<? extends LivingEntity>, Integer>();
    @Unique
    private final Set<ShapeType<?>> remorphed$favoriteShapes = new HashSet();
    @Unique
    private final String UNLOCKED_SHAPES = "UnlockedShapes";
    @Unique
    private final String FAVORITE_SHAPES = "FavoriteShapes";

    private PlayerEntityMixin(EntityType<? extends LivingEntity> type, Level world) {
        super(type, world);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void serverTick(CallbackInfo info) {
        if (!this.f_19853_.f_46443_) {
            Remorphed.sync((ServerPlayer)this);
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    private void readNbt(CompoundTag tag, CallbackInfo info) {
        this.remorphed$readData(tag.m_128469_("remorphed"));
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="RETURN")})
    private void writeNbt(CompoundTag tag, CallbackInfo info) {
        tag.m_128365_("remorphed", (Tag)this.remorphed$writeData());
    }

    @Unique
    private CompoundTag remorphed$writeData() {
        CompoundTag tag = new CompoundTag();
        ListTag unlockedList = new ListTag();
        this.remorphed$unlockedShapes.forEach((shape, killAmount) -> {
            if (killAmount > 0 && shape != null) {
                CompoundTag entryTag = new CompoundTag();
                entryTag.m_128359_("id", Registry.f_122826_.m_7981_((Object)shape.getEntityType()).toString());
                entryTag.m_128405_("variant", shape.getVariantData());
                entryTag.m_128405_("killAmount", killAmount.intValue());
                unlockedList.add((Object)entryTag);
            }
        });
        if (!this.remorphed$unlockedShapes.isEmpty()) {
            tag.m_128365_("UnlockedShapes", (Tag)unlockedList);
        }
        ListTag favoritesList = new ListTag();
        this.remorphed$favoriteShapes.forEach(shape -> {
            if (shape != null) {
                CompoundTag entryTag = new CompoundTag();
                entryTag.m_128359_("id", Registry.f_122826_.m_7981_((Object)shape.getEntityType()).toString());
                entryTag.m_128405_("variant", shape.getVariantData());
                favoritesList.add((Object)entryTag);
            }
        });
        if (!this.remorphed$favoriteShapes.isEmpty()) {
            tag.m_128365_("FavoriteShapes", (Tag)favoritesList);
        }
        return tag;
    }

    @Unique
    public void remorphed$readData(CompoundTag tag) {
        this.remorphed$unlockedShapes.clear();
        this.remorphed$favoriteShapes.clear();
        ListTag unlockedList = tag.m_128437_("UnlockedShapes", 10);
        unlockedList.forEach(entry -> {
            if (entry instanceof CompoundTag) {
                ResourceLocation typeId = new ResourceLocation(((CompoundTag)entry).m_128461_("id"));
                int typeVariantId = ((CompoundTag)entry).m_128451_("variant");
                int killAmount = ((CompoundTag)entry).m_128451_("killAmount");
                this.remorphed$unlockedShapes.put((ShapeType<? extends LivingEntity>)ShapeType.from((EntityType)((EntityType)Registry.f_122826_.m_7745_(typeId)), (int)typeVariantId), killAmount);
            }
        });
        ListTag favoritesList = tag.m_128437_("FavoriteShapes", 10);
        favoritesList.forEach(entry -> {
            if (entry instanceof CompoundTag) {
                ResourceLocation typeId = new ResourceLocation(((CompoundTag)entry).m_128461_("id"));
                int typeVariantId = ((CompoundTag)entry).m_128451_("variant");
                this.remorphed$favoriteShapes.add(ShapeType.from((EntityType)((EntityType)Registry.f_122826_.m_7745_(typeId)), (int)typeVariantId));
            }
        });
    }

    @Override
    @Unique
    public Map<ShapeType<? extends LivingEntity>, Integer> remorphed$getUnlockedShapes() {
        return this.remorphed$unlockedShapes;
    }

    @Override
    @Unique
    public void remorphed$addKill(ShapeType<? extends LivingEntity> type) {
        this.remorphed$unlockedShapes.put(type, this.remorphed$getKills(type) + 1);
    }

    @Override
    @Unique
    public int remorphed$getKills(ShapeType<? extends LivingEntity> type) {
        if (Walkers.CONFIG.unlockEveryVariant) {
            int killAmount = 0;
            for (Integer i : this.remorphed$unlockedShapes.entrySet().stream().filter(entry -> ((ShapeType)entry.getKey()).getEntityType().equals(type.getEntityType())).map(Map.Entry::getValue).toList()) {
                killAmount += i.intValue();
            }
            return killAmount;
        }
        return this.remorphed$unlockedShapes.getOrDefault(type, 0);
    }

    @Override
    @Unique
    public Set<ShapeType<?>> remorphed$getFavorites() {
        return this.remorphed$favoriteShapes;
    }
}

