/*
 * Decompiled with CFR 0.152.
 */
package tocraft.remorphed.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.EntitySummonArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.event.common.CommandEvents;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.impl.PlayerMorph;
import tocraft.walkers.api.PlayerShapeChanger;
import tocraft.walkers.api.variant.ShapeType;

public class RemorphedCommand
implements CommandEvents.CommandRegistration {
    private static int hasShape(CommandSourceStack source, ServerPlayer player, ResourceLocation id, @Nullable CompoundTag nbt) {
        ShapeType<LivingEntity> type = RemorphedCommand.getType(source.m_81372_(), id, nbt);
        TranslatableComponent name = new TranslatableComponent(type.getEntityType().m_20675_());
        if (PlayerMorph.getUnlockedShapes((Player)player).containsKey(type)) {
            source.m_81354_((Component)new TranslatableComponent("remorphed.hasShape_success", new Object[]{player.m_5446_(), name}), true);
            return 1;
        }
        source.m_81354_((Component)new TranslatableComponent("remorphed.hasShape_fail", new Object[]{player.m_5446_(), name}), true);
        return 0;
    }

    private static void removeShape(CommandSourceStack source, ServerPlayer player, ResourceLocation id, @Nullable CompoundTag nbt) {
        ShapeType<LivingEntity> type = RemorphedCommand.getType(source.m_81372_(), id, nbt);
        TranslatableComponent name = new TranslatableComponent(type.getEntityType().m_20675_());
        PlayerMorph.getUnlockedShapes((Player)player).remove(type);
        source.m_81354_((Component)new TranslatableComponent("remorphed.removeShape", new Object[]{name, player.m_5446_()}), true);
    }

    private static void addShape(CommandSourceStack source, ServerPlayer player, ResourceLocation id, @Nullable CompoundTag nbt) {
        ShapeType<LivingEntity> type = RemorphedCommand.getType(source.m_81372_(), id, nbt);
        TranslatableComponent name = new TranslatableComponent(type.getEntityType().m_20675_());
        PlayerMorph.getUnlockedShapes((Player)player).put(type, Remorphed.getKillToUnlock(type.getEntityType()));
        source.m_81354_((Component)new TranslatableComponent("remorphed.addShape", new Object[]{player.m_5446_(), name}), true);
    }

    private static void clearShapes(CommandSourceStack source, ServerPlayer player) {
        PlayerMorph.getUnlockedShapes((Player)player).clear();
        source.m_81354_((Component)new TranslatableComponent("remorphed.clearShapes", new Object[]{player.m_5446_()}), true);
        PlayerShapeChanger.change2ndShape((ServerPlayer)player, null);
    }

    private static ShapeType<LivingEntity> getType(ServerLevel serverLevel, ResourceLocation id, @Nullable CompoundTag nbt) {
        ShapeType type = new ShapeType((EntityType)Registry.f_122826_.m_7745_(id));
        if (nbt != null) {
            CompoundTag copy = nbt.m_6426_();
            copy.m_128359_("id", id.toString());
            Entity loaded = EntityType.m_20645_((CompoundTag)copy, (Level)serverLevel, it -> it);
            if (loaded instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)loaded;
                type = new ShapeType(living);
            }
        }
        return type;
    }

    public void register(CommandDispatcher<CommandSourceStack> dispatcher, Commands.CommandSelection selection) {
        LiteralCommandNode rootNode = ((LiteralArgumentBuilder)Commands.m_82127_((String)"remorphed").requires(source -> source.m_6761_(2))).build();
        LiteralCommandNode removeShape = ((LiteralArgumentBuilder)Commands.m_82127_((String)"removeShape").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"shape", (ArgumentType)EntitySummonArgument.m_93335_()).suggests(SuggestionProviders.f_121645_).executes(context -> {
            RemorphedCommand.removeShape((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), EntitySummonArgument.m_93338_((CommandContext)context, (String)"shape"), null);
            return 1;
        })).then(Commands.m_82129_((String)"nbt", (ArgumentType)CompoundTagArgument.m_87657_()).executes(context -> {
            CompoundTag nbt = CompoundTagArgument.m_87660_((CommandContext)context, (String)"nbt");
            RemorphedCommand.removeShape((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), EntitySummonArgument.m_93338_((CommandContext)context, (String)"shape"), nbt);
            return 1;
        }))))).build();
        LiteralCommandNode addShape = ((LiteralArgumentBuilder)Commands.m_82127_((String)"addShape").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"shape", (ArgumentType)EntitySummonArgument.m_93335_()).suggests(SuggestionProviders.f_121645_).executes(context -> {
            RemorphedCommand.addShape((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), EntitySummonArgument.m_93338_((CommandContext)context, (String)"shape"), null);
            return 1;
        })).then(Commands.m_82129_((String)"nbt", (ArgumentType)CompoundTagArgument.m_87657_()).executes(context -> {
            CompoundTag nbt = CompoundTagArgument.m_87660_((CommandContext)context, (String)"nbt");
            RemorphedCommand.addShape((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), EntitySummonArgument.m_93338_((CommandContext)context, (String)"shape"), nbt);
            return 1;
        }))))).build();
        LiteralCommandNode clearShapes = ((LiteralArgumentBuilder)Commands.m_82127_((String)"clearShapes").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).executes(context -> {
            RemorphedCommand.clearShapes((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"));
            return 1;
        }))).build();
        LiteralCommandNode hasShape = ((LiteralArgumentBuilder)Commands.m_82127_((String)"hasShape").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"shape", (ArgumentType)EntitySummonArgument.m_93335_()).suggests(SuggestionProviders.f_121645_).executes(context -> RemorphedCommand.hasShape((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), EntitySummonArgument.m_93338_((CommandContext)context, (String)"shape"), null))).then(Commands.m_82129_((String)"nbt", (ArgumentType)CompoundTagArgument.m_87657_()).executes(context -> {
            CompoundTag nbt = CompoundTagArgument.m_87660_((CommandContext)context, (String)"nbt");
            return RemorphedCommand.hasShape((CommandSourceStack)context.getSource(), EntityArgument.m_91474_((CommandContext)context, (String)"player"), EntitySummonArgument.m_93338_((CommandContext)context, (String)"shape"), nbt);
        }))))).build();
        rootNode.addChild((CommandNode)removeShape);
        rootNode.addChild((CommandNode)addShape);
        rootNode.addChild((CommandNode)clearShapes);
        rootNode.addChild((CommandNode)hasShape);
        dispatcher.getRoot().addChild((CommandNode)rootNode);
    }
}

