package tocraft.remorphed.screen.widget;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1299;
import net.minecraft.class_1493;
import net.minecraft.class_1921;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.network.NetworkHandler;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.variant.ShapeType;
import tocraft.walkers.api.variant.TypeProvider;
import tocraft.walkers.api.variant.TypeProviderRegistry;
import tocraft.walkers.network.impl.SwapVariantPackets;

import java.util.Objects;
import java.util.UUID;

@Environment(EnvType.CLIENT)
public class SpecialShapeWidget extends class_4264 {
    private final class_437 parent;
    private final boolean isCurrent;
    private final boolean isAvailable;

    public SpecialShapeWidget(int x, int y, int width, int height, class_437 parent) {
        super(x, y, width, height, class_2561.method_30163(""));
        this.parent = parent;

        // check if current shape is the special shape
        class_2487 nbt = new class_2487();
        if (class_310.method_1551().field_1724 != null && PlayerShape.getCurrentShape(class_310.method_1551().field_1724) instanceof class_1493 wolf) {
            wolf.method_5647(nbt);
        }
        this.isCurrent = nbt.method_10545("isSpecial") && nbt.method_10577("isSpecial");
        this.isAvailable = class_310.method_1551().field_1724 != null && Remorphed.canUseShape(class_310.method_1551().field_1724, class_1299.field_6055);
        method_47400(class_7919.method_47407(class_2561.method_43471(isAvailable ? "remorphed.special_shape_available" : "remorphed.special_shape_unavailable")));
    }

    @Override
    public void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        guiGraphics.method_25302(class_1921::method_62277, Remorphed.id("textures/gui/wolf.png"), method_46426(), method_46427(), 0, 0, method_25368(), method_25364(), 15, 15, 15, 15);

        if (!isCurrent && !isAvailable) {
            guiGraphics.method_25302(class_1921::method_62277, Remorphed.id("textures/gui/unavailable.png"), method_46426(), method_46427(), 0, 0, method_25368(), method_25364(), 15, 15, 15, 15);
        }

        // Highlight when focused
        if (method_25367()) {
            guiGraphics.method_25302(class_1921::method_62277, Remorphed.id("textures/gui/head_focus.png"), method_46426(), method_46427(), 0, 0, method_25368(), method_25364(), 16, 16, 16, 16);
        }
    }

    @Override
    public void method_25306() {
        UUID profileId = class_310.method_1551().method_1548().method_44717();
        if (!isCurrent && isAvailable && Walkers.hasSpecialShape(profileId)) {
            // get variant range
            TypeProvider<class_1493> typeProvider = TypeProviderRegistry.getProvider(class_1299.field_6055);
            int range = typeProvider != null ? typeProvider.getRange() : -1;
            // swap to variant
            NetworkHandler.sendSwap2ndShapeRequest(Objects.requireNonNull(ShapeType.from(class_1299.field_6055, -1)));
            SwapVariantPackets.sendSwapRequest(range + 1);
            parent.method_25419();
        }
    }

    @Override
    public void method_47399(class_6382 builder) {

    }
}
