package tocraft.remorphed.screen.widget;

import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_6382;
import tocraft.remorphed.Remorphed;

public abstract class ShapeWidget extends class_4264 {
    private final class_437 parent;
    private boolean crashed = false;
    private boolean isFavorite;
    private final boolean isCurrent;
    private final int availability;

    public ShapeWidget(float x, float y, float width, float height, class_437 parent, boolean isFavorite, boolean isCurrent, int availability) {
        super((int) x, (int) y, (int) width, (int) height, class_2561.method_30163(""));
        this.parent = parent;
        this.isFavorite = isFavorite;
        this.isCurrent = isCurrent;
        this.availability = availability;
    }

    protected abstract void sendFavoriteRequest(boolean isFavorite);

    protected abstract void sendSwap2ndShapeRequest();

    protected abstract void renderShape(class_332 guiGraphics);

    protected void setCrashed() {
        this.crashed = true;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        // Add to favorites
        if (method_49606() && class_310.method_1551().field_1724 != null && button == 1) {
            isFavorite = !isFavorite;
            sendFavoriteRequest(isFavorite);
        }

        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        if (!crashed) {
            // make the widget is even DARKER when hovered
            if (method_25367()) {
                guiGraphics.method_25302(class_1921::method_62277, Remorphed.id("textures/gui/focused.png"), method_46426(), method_46427(), 0, 0, method_25368(), method_25364(), 48, 32, 48, 32);
            }

            if (Remorphed.displayDataInMenu && availability != -1) {
                String s = String.valueOf(availability);
                int w = parent.method_64506().method_1727(s);
                guiGraphics.method_51433(parent.method_64506(), s, method_46426() + method_25368() - w - method_25368() / 8, (int) (method_46427() + method_25364() * 0.125), 0xFFFFFF, false);
                guiGraphics.method_51452();
            }

            renderShape(guiGraphics);

            // Render selected outline
            if (isCurrent) {
                guiGraphics.method_25302(class_1921::method_62277, Remorphed.id("textures/gui/selected.png"), method_46426(), method_46427(), 0, 0, method_25368(), method_25364(), 48, 32, 48, 32);
            }
            // Render favorite
            if (isFavorite) {
                guiGraphics.method_25302(class_1921::method_62277, Remorphed.id("textures/gui/favorite.png"), method_46426(), method_46427(), 0, 0, method_25368(), method_25364(), 48, 32, 48, 32);
            }
        }
    }

    @Override
    public void method_25306() {
        // switch to new shape
        if (!isCurrent) {
            // Update 2nd Shape
            sendSwap2ndShapeRequest();
            // close active screen handler
            parent.method_25419();
        }
    }

    @Override
    public void method_47399(class_6382 builder) {

    }
}
