package tocraft.remorphed.screen.widget;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_6379;
import net.minecraft.class_8132;
import org.jetbrains.annotations.NotNull;
import tocraft.remorphed.Remorphed;

import java.util.List;

@SuppressWarnings("UnusedReturnValue")
@Environment(EnvType.CLIENT)
public class ShapeListWidget extends class_4265<ShapeListWidget.ShapeRow> {
    private static final int ITEM_HEIGHT = 35;

    public ShapeListWidget(class_310 minecraft, int width, @NotNull class_8132 layout) {
        super(minecraft, width, layout.method_57727(), layout.method_48998(), ITEM_HEIGHT);
    }

    public int addRow(ShapeWidget[] widgets) {
        return method_25321(new ShapeRow(widgets));
    }

    public int rowHeight() {
        return field_22741;
    }

    @Override
    public void method_25339() {
        super.method_25339();
    }

    public static class ShapeRow extends class_4265.class_4266<ShapeRow> {
        private final ShapeWidget[] widgets;

        public ShapeRow(ShapeWidget[] widgets) {
            this.widgets = widgets;
        }

        @Override
        public void method_25343(@NotNull class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float delta) {
            for (int i = 0; i < widgets.length; i++) {
                ShapeWidget widget = widgets[i];

                if (widget != null) {
                    int w = width / Remorphed.CONFIG.shapes_per_row;

                    widget.method_48229(left + w * i, top);
                    widget.method_55445(w, height);
                    widget.method_25394(guiGraphics, mouseX, mouseY, delta);
                }
            }
        }

        @Override
        public @NotNull List<? extends class_364> method_25396() {
            return List.of(widgets);
        }

        @Override
        public @NotNull List<? extends class_6379> method_37025() {
            return List.of(widgets);
        }
    }

    @Override
    public int method_25322() {
        return Remorphed.CONFIG.row_width;
    }

    @Override
    protected void method_57715(class_332 guiGraphics) {
    }

    //#if MC<=1212
    //$$ @Override
    //$$ protected boolean isValidMouseClick(int button) {
    //$$     return true;
    //$$ }
    //#endif
}
