package tocraft.remorphed.screen.widget;

import com.mojang.authlib.GameProfile;
import dev.tocraft.skinshifter.SkinShifter;
import dev.tocraft.skinshifter.data.SkinPlayerData;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_6382;
import net.minecraft.class_742;
import net.minecraft.class_7919;
import net.minecraft.class_8685;
import org.jetbrains.annotations.NotNull;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.network.NetworkHandler;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.network.impl.SwapPackets;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;

@Environment(EnvType.CLIENT)
public class PlayerWidget extends class_4264 {
    private final class_437 parent;
    private final boolean willCache = true;

    public PlayerWidget(int x, int y, int width, int height, class_437 parent) {
        super(x, y, width, height, class_2561.method_30163("Head"));
        this.parent = parent;
        method_47400(class_7919.method_47407(class_2561.method_43471("remorphed.player_icon")));
    }

    @Override
    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        class_742 player = class_310.method_1551().field_1724;
        if (player != null) {
            class_2960 skinLocation = player.method_52814().comp_1626();
            if (Remorphed.foundSkinShifter && !player.method_5667().equals(SkinShifter.getCurrentSkin(player))) {
                // still render own skin as icon when in another skin
                var skin = getPlayerSkin(player);
                skinLocation = skin.getNow(Optional.empty()).map(class_8685::comp_1626).orElse(skinLocation);
            }

            guiGraphics.method_25302(class_1921::method_62277, skinLocation, method_46426(), method_46427(), 8.0f, 8, method_25368(), method_25364(), 8, 8, 64, 64);
            guiGraphics.method_25302(class_1921::method_62277, skinLocation, method_46426(), method_46427(), 40.0f, 8, method_25368(), method_25364(), 8, 8, 64, 64);
        }

        // Highlight when focused
        if (method_25367()) {
            guiGraphics.method_25302(class_1921::method_62277, Remorphed.id("textures/gui/head_focus.png"), method_46426(), method_46427(), 0, 0, method_25368(), method_25364(), 16, 16, 16, 16);
        }
    }

    @Override
    public void method_25306() {
        if (class_310.method_1551().field_1724 != null) {
            if (PlayerShape.getCurrentShape(class_310.method_1551().field_1724) != null) {
                SwapPackets.sendSwapRequest();
                parent.method_25419();
            }
            if (Remorphed.foundSkinShifter && SkinShifter.getCurrentSkin(class_310.method_1551().field_1724) != class_310.method_1551().field_1724.method_5667()) {
                NetworkHandler.sendResetSkinPacket();
                parent.method_25419();
            }
        }
    }

    @Override
    public void method_47399(class_6382 builder) {

    }

    private static @NotNull CompletableFuture<Optional<class_8685>> getPlayerSkin(class_1657 player) {
        CompletableFuture<Optional<GameProfile>> profileFuture = SkinPlayerData.getSkinProfile(player.method_5667());
        return profileFuture.thenApply((profile) -> profile.map((gameProfile) -> class_310.method_1551().method_1582().method_52862(gameProfile)));
    }
}
