package tocraft.remorphed.screen.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4597;
import net.minecraft.class_490;
import net.minecraft.class_7919;
import net.minecraft.class_898;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.network.NetworkHandler;
import tocraft.walkers.api.variant.ShapeType;
import tocraft.walkers.traits.ShapeTrait;
import tocraft.walkers.traits.TraitRegistry;

import java.util.ArrayList;
import java.util.List;

@Environment(EnvType.CLIENT)
public class EntityWidget<T extends class_1309> extends ShapeWidget {

    private final ShapeType<T> type;
    private final T entity;
    private final int size;

    public EntityWidget(int x, int y, int width, int height, ShapeType<T> type, @NotNull T entity, class_437 parent, boolean isFavorite, boolean current, int availability) {
        super(x, y, width, height, parent, isFavorite, current, availability); // int x, int y, int width, int height, message
        this.size = (int) (Remorphed.CONFIG.entity_size * (1 / (Math.max(entity.method_17682(), entity.method_17681()))));
        this.type = type;
        this.entity = entity;
        entity.method_5834(true);
        method_47400(class_7919.method_47407(ShapeType.createTooltipText(entity)));
    }

    @Override
    protected void sendFavoriteRequest(boolean isFavorite) {
        NetworkHandler.sendFavoriteRequest(type, isFavorite);
    }

    @Override
    protected void sendSwap2ndShapeRequest() {
        NetworkHandler.sendSwap2ndShapeRequest(type);
    }

    @Override
    protected void renderShape(class_332 guiGraphics) {
        if (Remorphed.displayDataInMenu) {
            int iconS = field_22758 / 5;


            // Render Trait Icons first
            int blitOffset = 0;
            int rowIndex = 0;
            List<class_2960> renderedTraits = new ArrayList<>();
            List<ShapeTrait<T>> traits = TraitRegistry.getAll(entity);
            for (ShapeTrait<T> trait : traits) {
                if (trait != null && trait.getIcon() != null && (!renderedTraits.contains(trait.getId()) || trait.iconMightDiffer())) {
                    guiGraphics.method_52709(class_1921::method_62277, trait.getIcon(), method_46426() + rowIndex, method_46427() + blitOffset, iconS, iconS);
                    // prevent infinite amounts of traits to be rendered
                    if (blitOffset >= method_25364() - iconS) {
                        rowIndex += iconS;
                        blitOffset = 0;
                    } else {
                        blitOffset += iconS;
                    }
                    if (rowIndex >= method_25368() - iconS) {
                        break;
                    }
                    renderedTraits.add(trait.getId());
                }
            }
        }

        // Some entities (namely Aether mobs) crash when rendered in a GUI.
        // Unsure as to the cause, but this try/catch should prevent the game from entirely dipping out.
        try {
            // ARGH
            class_490.method_48472(guiGraphics, method_46426() + (float) this.method_25368() / 2, (int) (method_46427() + this.method_25364() * .75f), size, new Vector3f(), new Quaternionf().rotationXYZ(0.43633232F, (float) Math.PI, (float) Math.PI), null, entity);
        } catch (Exception e) {
            Remorphed.LOGGER.error("Error while rendering {}", ShapeType.createTooltipText(entity).getString(), e);
            setCrashed();
            class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
            immediate.method_22993();
            class_898 entityRenderDispatcher = class_310.method_1551().method_1561();
            entityRenderDispatcher.method_3948(true);
            RenderSystem.getModelViewStack().popMatrix();
            class_308.method_24211();
        }
    }

}
