package tocraft.remorphed.screen;

import com.mojang.authlib.GameProfile;
import dev.tocraft.skinshifter.SkinShifter;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_742;
import net.minecraft.class_7919;
import net.minecraft.class_8132;
import net.minecraft.class_8667;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.impl.FakeClientPlayer;
import tocraft.remorphed.impl.PlayerMorph;
import tocraft.remorphed.mixin.accessor.ScreenAccessor;
import tocraft.remorphed.screen.widget.*;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.variant.ShapeType;

import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

@Environment(EnvType.CLIENT)
public class RemorphedMenu extends class_437 {
    @Nullable
    protected ShapeListWidget list;
    public final class_8132 layout = new class_8132(this);
    private static String lastSearchContents = "";

    private final List<ShapeType<?>> unlockedShapes = new CopyOnWriteArrayList<>();
    private final List<GameProfile> unlockedSkins = new CopyOnWriteArrayList<>();
    private final Map<ShapeType<?>, class_1308> renderEntities = new ConcurrentHashMap<>();
    private final Map<GameProfile, FakeClientPlayer> renderPlayers = new ConcurrentHashMap<>();

    private final class_4185 variantsButton = createVariantsButton();
    private final SearchWidget searchBar = createSearchBar();
    private final class_4185 helpButton = createHelpButton();
    private final PlayerWidget playerButton = createPlayerButton();
    private final SpecialShapeWidget specialShapeButton = createSpecialShapeButton();
    private final class_4185 traitsButton = createTraitsButton();

    public RemorphedMenu() {
        super(class_2561.method_43470("ReMorphed Menu"));
    }

    protected void method_25426() {
        this.addHeader();
        this.addContents();
        this.addFooter();
        this.layout.method_48206(this::method_37063);
        this.method_48640();
    }

    protected void addHeader() {
        class_8667 linearLayout = this.layout.method_48992(class_8667.method_52742()).method_52735(8);

        linearLayout.method_52736(variantsButton);
        linearLayout.method_52736(searchBar);
        linearLayout.method_52736(helpButton);
        linearLayout.method_52736(playerButton);

        if (field_22787 != null && field_22787.field_1724 != null && Walkers.hasSpecialShape(field_22787.field_1724.method_5667())) {
            linearLayout.method_52736(specialShapeButton);
        }

        linearLayout.method_52736(traitsButton);
    }

    protected void addContents() {
        this.list = this.layout.method_48999(new ShapeListWidget(this.field_22787, this.field_22789, this.layout));

        if (field_22787 != null && field_22787.field_1724 != null) {
            populateUnlockedRenderEntities(field_22787.field_1724);

            ShapeType<? extends class_1309> currentShape = ShapeType.from(PlayerShape.getCurrentShape(field_22787.field_1724));

            // handle favorites
            unlockedShapes.sort((first, second) -> {
                // sort by selected
                if (Remorphed.CONFIG.sort_selected) {
                    if (Objects.equals(first, currentShape)) {
                        return -1;
                    } else if (Objects.equals(second, currentShape)) {
                        return 1;
                    }
                }
                // sort by favorite
                boolean firstIsFav = PlayerMorph.getFavoriteShapes(field_22787.field_1724).contains(first);
                boolean secondIsFav = PlayerMorph.getFavoriteShapes(field_22787.field_1724).contains(second);
                if (firstIsFav == secondIsFav) {
                    return 0;
                } else if (firstIsFav) {
                    return -1;
                } else {
                    return 1;
                }
            });


            // filter unlocked
            if (!Remorphed.displayVariantsInMenu) {
                List<ShapeType<?>> newUnlocked = new ArrayList<>();
                for (ShapeType<?> shapeType : unlockedShapes) {
                    if (shapeType.equals(currentShape) || !newUnlocked.stream().map(ShapeType::getEntityType).toList().contains(shapeType.getEntityType())) {
                        newUnlocked.add(shapeType);
                    }
                }

                unlockedShapes.clear();
                unlockedShapes.addAll(newUnlocked);
            }

            if (Remorphed.foundSkinShifter) {
                populateUnlockedRenderPlayers(field_22787.field_1724);
                UUID currentSkin = SkinShifter.getCurrentSkin(field_22787.field_1724);

                unlockedSkins.sort((first, second) -> {
                    if (Objects.equals(first.getId(), currentSkin) && currentShape != null) {
                        return -1;
                    } else if (Objects.equals(second.getId(), currentSkin) && currentShape != null) {
                        return 1;
                    } else {
                        boolean firstIsFav = PlayerMorph.getFavoriteSkinIds(field_22787.field_1724).contains(first.getId());
                        boolean secondIsFav = PlayerMorph.getFavoriteSkinIds(field_22787.field_1724).contains(second.getId());
                        if (firstIsFav == secondIsFav) {
                            return first.getName().compareTo(second.getName());
                        } else if (firstIsFav) {
                            return -1;
                        } else {
                            return 1;
                        }
                    }
                });
            }
        }

        // implement search handler and display matching entities
        searchBar.method_1863(text -> {
            // re-filter if the text contents changed
            ((ScreenAccessor) this).getNarratables().removeIf(button -> button instanceof EntityWidget);
            method_25396().removeIf(button -> button instanceof EntityWidget);

            List<ShapeType<?>> filteredShapes = unlockedShapes
                    .stream()
                    .filter(type -> text.isEmpty() || ShapeType.createTooltipText(renderEntities.get(type)).getString().toUpperCase().contains(text.toUpperCase()) || class_1299.method_5890(type.getEntityType()).toString().toUpperCase().contains(text.toUpperCase()))
                    .toList();
            List<GameProfile> filteredSkins = unlockedSkins
                    .stream()
                    .filter(skin -> text.isEmpty() || skin.getName().toUpperCase().contains(text.toUpperCase()) || skin.getId().toString().contains(text.toUpperCase()))
                    .toList();

            populateShapeWidgets(filteredShapes, filteredSkins);

            lastSearchContents = text;
        });
        searchBar.method_1867(lastSearchContents);
    }

    @Override
    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        // make the background DARK
        method_52752(guiGraphics);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
    }

    @SuppressWarnings("unchecked")
    private void populateShapeWidgets(@NotNull List<ShapeType<?>> rendered, @NotNull List<GameProfile> skinProfiles) {
        if (this.list != null && field_22787 != null && field_22787.field_1724 != null) {
            this.list.method_25339();

            // add widget for each entity to be rendered
            int rows = (int) Math.ceil((float) (rendered.size() + skinProfiles.size()) / Remorphed.CONFIG.shapes_per_row);

            ShapeType<class_1309> currentType = ShapeType.from(PlayerShape.getCurrentShape(field_22787.field_1724));
            int currentRow = 0;

            for (int i = 0; i <= rows; i++) {
                List<ShapeWidget> row = new ArrayList<>();

                for (int j = 0; j < Remorphed.CONFIG.shapes_per_row; j++) {
                    int listIndex = i * Remorphed.CONFIG.shapes_per_row + j;

                    if (Remorphed.foundSkinShifter && listIndex < skinProfiles.size()) {
                        GameProfile skinProfile = skinProfiles.get(listIndex);
                        class_742 fakePlayer = renderPlayers.get(skinProfile);
                        if (fakePlayer != null) {
                            boolean bl = Objects.equals(SkinShifter.getCurrentSkin(field_22787.field_1724), skinProfile.getId()) && currentType == null;
                            if (bl) currentRow = i;
                            row.add(new SkinWidget(
                                    0,
                                    0,
                                    0,
                                    0,
                                    skinProfile,
                                    new FakeClientPlayer(field_22787.field_1687, skinProfile),
                                    this,
                                    PlayerMorph.getFavoriteSkins(field_22787.field_1724).contains(skinProfile),
                                    bl,
                                    Remorphed.canUseEveryShape(field_22787.field_1724) || Remorphed.CONFIG.playerKillValue < 1 ? -1 : Remorphed.CONFIG.playerKillValue * PlayerMorph.getPlayerKills(field_22787.field_1724, skinProfile.getId()) - PlayerMorph.getCounter(field_22787.field_1724, skinProfile.getId())
                            ));
                        } else {
                            Remorphed.LOGGER.error("invalid skin profile: {}", skinProfile);
                        }
                    } else if (listIndex < skinProfiles.size() + rendered.size()) {
                        ShapeType<?> type = rendered.get(listIndex - skinProfiles.size());
                        class_1308 entity = renderEntities.get(type);
                        if (entity != null) {
                            boolean bl = type.equals(currentType);
                            if (bl) currentRow = i;
                            row.add(new EntityWidget<>(
                                    0,
                                    0,
                                    0,
                                    0,
                                    (ShapeType<class_1308>) type,
                                    entity,
                                    this,
                                    PlayerMorph.getFavoriteShapes(field_22787.field_1724).contains(type),
                                    bl,
                                    Remorphed.canUseEveryShape(field_22787.field_1724) || Remorphed.getKillValue(type.getEntityType()) < 1 ? -1 : Remorphed.getKillValue(type.getEntityType()) * PlayerMorph.getKills(field_22787.field_1724, type) - PlayerMorph.getCounter(field_22787.field_1724, type)
                            ));
                            Remorphed.LOGGER.warn("Entity: {} with: {}", type.getEntityType(), PlayerMorph.getCounter(field_22787.field_1724, type));
                        } else {
                            Remorphed.LOGGER.error("invalid shape type: {}", type.getEntityType().method_5882());
                        }
                    }
                }

                this.list.addRow(row.toArray(ShapeWidget[]::new));
            }

            if (Remorphed.CONFIG.focus_selected) {
                // auto center the selected shape
                this.list.method_44382((double) this.list.rowHeight() * (currentRow - 2));
            }
        }
    }

    public synchronized void populateUnlockedRenderEntities(class_1657 player) {
        unlockedShapes.clear();
        renderEntities.clear();
        List<ShapeType<?>> validUnlocked = Remorphed.getUnlockedShapes(player);
        for (ShapeType<?> type : validUnlocked) {
            class_1297 entity = type.create(class_310.method_1551().field_1687, player);
            if (entity instanceof class_1308 living) {
                unlockedShapes.add(type);
                renderEntities.put(type, living);
            }
        }

        Remorphed.LOGGER.info("Loaded {} entities for rendering", unlockedShapes.size());
    }

    public synchronized void populateUnlockedRenderPlayers(class_1657 player) {
        unlockedSkins.clear();
        renderPlayers.clear();
        List<GameProfile> validUnlocked = Remorphed.getUnlockedSkins(player);
        for (GameProfile profile : validUnlocked) {
            if (profile.getId() != player.method_5667()) {
                FakeClientPlayer entity = null;
                if (field_22787 != null) {
                    entity = new FakeClientPlayer(field_22787.field_1687, profile);
                }
                unlockedSkins.add(profile);
                renderPlayers.put(profile, entity);
            }
        }

        Remorphed.LOGGER.info("Loaded {} players for rendering", unlockedSkins.size());
    }

    protected void addFooter() {
        this.layout.method_48996(class_4185.method_46430(class_5244.field_24334, (button) -> this.method_25419()).method_46432(200).method_46431());
    }

    protected void method_48640() {
        this.layout.method_48222();
        if (this.list != null) {
            this.list.method_57712(this.field_22789, this.layout);
        }
    }

    @Contract(" -> new")
    private @NotNull SearchWidget createSearchBar() {
        return new SearchWidget(
                0,
                0,
                getWindow().method_4486() / 4f,
                20f);
    }

    private @NotNull class_4185 createHelpButton() {
        class_4185.class_7840 helpButton = class_4185.method_46430(class_2561.method_30163("?"), (widget) -> class_310.method_1551().method_1507(new RemorphedHelpScreen()));

        helpButton.method_46437(20, 20);
        helpButton.method_46436(class_7919.method_47407(class_2561.method_43471(Remorphed.MODID + ".help")));
        return helpButton.method_46431();
    }

    private @NotNull class_4185 createVariantsButton() {
        class_2561 text = class_2561.method_43471("remorphed.display_variants");
        class_4185.class_7840 variantsButton = class_4185.method_46430(text, (widget) -> {
            Remorphed.displayVariantsInMenu = !Remorphed.displayVariantsInMenu;
            class_310.method_1551().method_1507(new RemorphedMenu());
        });


        variantsButton.method_46437(class_310.method_1551().field_1772.method_1727(text.getString()) + 20, 20);
        variantsButton.method_46436(class_7919.method_47407(class_2561.method_43471(Remorphed.MODID + ".variants")));

        return variantsButton.method_46431();
    }

    private @NotNull class_4185 createTraitsButton() {
        class_2561 text = class_2561.method_43471("remorphed.show_traits");
        class_4185.class_7840 traitButton = class_4185.method_46430(text, (widget) -> Remorphed.displayDataInMenu = !Remorphed.displayDataInMenu);

        traitButton.method_46437(class_310.method_1551().field_1772.method_1727(text.getString()) + 20, 20);
        traitButton.method_46436(class_7919.method_47407(class_2561.method_43471(Remorphed.MODID + ".traits")));

        return traitButton.method_46431();
    }

    @Contract(" -> new")
    private @NotNull PlayerWidget createPlayerButton() {
        return new PlayerWidget(
                0,
                0,
                20,
                20,
                this);
    }

    @Contract(" -> new")
    private @NotNull SpecialShapeWidget createSpecialShapeButton() {
        return new SpecialShapeWidget(
                0,
                0,
                20,
                20,
                this);
    }

    private @NotNull class_1041 getWindow() {
        return class_310.method_1551().method_22683();
    }
}
