package tocraft.remorphed.network;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.client.CraftedCoreClient;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.craftedcore.network.client.ClientNetworking.ApplicablePacket;
import tocraft.remorphed.impl.PlayerMorph;
import tocraft.walkers.api.variant.ShapeType;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

@Environment(EnvType.CLIENT)
public class ClientNetworking {
    public static void registerPacketHandlers() {
        ModernNetworking.registerReceiver(ModernNetworking.Side.S2C, NetworkHandler.UNLOCKED_SYNC,
                ClientNetworking::handleUnlockedSyncPacket);
        ModernNetworking.registerReceiver(ModernNetworking.Side.S2C, NetworkHandler.FAVORITE_SYNC, ClientNetworking::handleFavoriteSyncPacket);
    }

    @SuppressWarnings("unchecked")
    public static void handleUnlockedSyncPacket(ModernNetworking.Context context, @NotNull class_2487 compound) {
        final UUID uuid = compound.method_25926("uuid");
        final Map<ShapeType<?>, Integer> unlockedShapes = new HashMap<>();
        if (compound.method_10545("UnlockedShapes")) {
            compound.method_10554("UnlockedShapes", class_2520.field_33260).forEach(entryTag -> {
                class_1299<? extends class_1309> eType = (class_1299<? extends class_1309>) class_7923.field_41177.method_10223(class_2960.method_60654(((class_2487) entryTag).method_10558("id"))).map(class_6880::comp_349).orElse(null);
                int variant = ((class_2487) entryTag).method_10550("variant");
                int killAmount = ((class_2487) entryTag).method_10550("killAmount");
                unlockedShapes.put(ShapeType.from(eType, variant), killAmount);
            });
        }
        final Map<UUID, Integer> unlockedSkins = new HashMap<>();
        if (compound.method_10545("UnlockedSkins")) {
            compound.method_10554("UnlockedSkins", class_2520.field_33260).forEach(entryTag -> {
                UUID unlockedSkinUUID = ((class_2487) entryTag).method_25926("uuid");
                int killAmount = ((class_2487) entryTag).method_10550("killAmount");
                unlockedSkins.put(unlockedSkinUUID, killAmount);
            });
        }

        final Map<ShapeType<?>, Integer> shapeCounter = new HashMap<>();
        final Map<UUID, Integer> skinCounter = new HashMap<>();
        if (compound.method_10545("MorphCounter")) {
            compound.method_10554("MorphCounter", class_2520.field_33260).forEach(entry -> {
                boolean isSkin = ((class_2487) entry).method_10577("isSkin");
                int count = ((class_2487) entry).method_10550("counter");
                if (isSkin) {
                    UUID skinId = ((class_2487) entry).method_25926("uuid");
                    skinCounter.put(skinId, count);
                } else {
                    class_2960 typeId = class_2960.method_60654(((class_2487) entry).method_10558("id"));
                    int typeVariantId = ((class_2487) entry).method_10550("variant");
                    shapeCounter.put(ShapeType.from((class_1299<? extends class_1309>) class_7923.field_41177.method_10223(typeId).map(class_6880::comp_349).orElse(null), typeVariantId), count);
                }
            });
        }

        runOrQueue(context, player -> {
            @Nullable
            class_1657 syncTarget = player.method_5770().method_18470(uuid);

            if (syncTarget != null) {
                PlayerMorph.getUnlockedShapes(player).clear();
                PlayerMorph.getUnlockedShapes(player).putAll(unlockedShapes);
                PlayerMorph.getUnlockedSkinIds(player).clear();
                PlayerMorph.getUnlockedSkinIds(player).putAll(unlockedSkins);
                PlayerMorph.getShapeCounter(player).clear();
                PlayerMorph.getShapeCounter(player).putAll(shapeCounter);
                PlayerMorph.getSkinCounter(player).clear();
                PlayerMorph.getSkinCounter(player).putAll(skinCounter);
            }
        });
    }


    private static void handleFavoriteSyncPacket(ModernNetworking.Context context, class_2487 tag) {
        ClientNetworking.runOrQueue(context, player -> {
            PlayerMorph.getFavoriteShapes(player).clear();
            PlayerMorph.getFavoriteSkinIds(player).clear();
            class_2499 shapeIds = tag.method_10554("FavoriteShapes", class_2520.field_33260);
            class_2499 skinIds = tag.method_10554("FavoriteSkins", class_2520.field_33261);
            shapeIds.forEach(compound -> PlayerMorph.getFavoriteShapes(player).add(ShapeType.from((class_2487) compound)));
            skinIds.forEach(skinId -> PlayerMorph.getFavoriteSkinIds(player).add(class_2512.method_25930(skinId)));
        });
    }

    public static void runOrQueue(ModernNetworking.@NotNull Context context, ApplicablePacket packet) {
        if (context.getPlayer() == null) {
            CraftedCoreClient.getSyncPacketQueue().add(packet);
        } else {
            context.queue(() -> packet.apply(context.getPlayer()));
        }
    }
}
