package tocraft.remorphed.mixin;

import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.impl.RemorphedPlayerDataProvider;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShapeChanger;
import tocraft.walkers.api.variant.ShapeType;

import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

@SuppressWarnings({"DataFlowIssue", "resource", "ControlFlowStatementWithoutBraces", "unused"})
@Mixin(class_1657.class)
public abstract class PlayerEntityMixin extends class_1309 implements RemorphedPlayerDataProvider {
    @Shadow
    public abstract boolean isCreative();

    @Unique
    private final Map<ShapeType<? extends class_1309>, Integer> remorphed$unlockedShapes = new HashMap<>();
    @Unique
    private final Set<ShapeType<?>> remorphed$favoriteShapes = new HashSet<>();
    @Unique
    private final Map<UUID, Integer> remorphed$unlockedSkins = new ConcurrentHashMap<>();
    @Unique
    private final Set<UUID> remorphed$favoriteSkins = new CopyOnWriteArraySet<>();
    @Unique
    private final Map<ShapeType<?>, Integer> remorphed$ShapeMorphCounter = new ConcurrentHashMap<>();
    @Unique
    private final Map<UUID, Integer> remorphed$SkinMorphCounter = new ConcurrentHashMap<>();
    @Unique
    private static final String UNLOCKED_SHAPES = "UnlockedShapes";
    @Unique
    private static final String FAVORITE_SHAPES = "FavoriteShapes";
    @Unique
    private static final String UNLOCKED_SKINS = "UnlockedSkins";
    @Unique
    private static final String FAVORITE_SKINS = "FavoriteSkins";
    @Unique
    private static final String MORPH_COUNTER = "MorphCounter";

    private PlayerEntityMixin(class_1299<? extends class_1309> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method = "tick", at = @At("HEAD"))
    private void serverTick(CallbackInfo info) {
        if (!this.method_37908().field_9236) {
            Remorphed.sync((class_3222) (Object) this);
        }
    }

    @Inject(method = "readAdditionalSaveData", at = @At("RETURN"))
    private void readNbt(@NotNull class_2487 tag, CallbackInfo info) {
        remorphed$readData(tag.method_10562(Remorphed.MODID));
    }

    @Inject(method = "addAdditionalSaveData", at = @At("RETURN"))
    private void writeNbt(@NotNull class_2487 tag, CallbackInfo info) {
        tag.method_10566(Remorphed.MODID, remorphed$writeData());
    }

    @Unique
    private @NotNull class_2487 remorphed$writeData() {
        class_2487 tag = new class_2487();
        class_2499 unlockedShapes = new class_2499();
        remorphed$unlockedShapes.forEach((shape, killAmount) -> {
            if (killAmount > 0 && shape != null) {
                class_2487 entryTag = new class_2487();
                entryTag.method_10582("id", class_1299.method_5890(shape.getEntityType()).toString());
                entryTag.method_10569("variant", shape.getVariantData());
                entryTag.method_10569("killAmount", killAmount);
                unlockedShapes.add(entryTag);
            }
        });
        if (!unlockedShapes.isEmpty()) {
            tag.method_10566(UNLOCKED_SHAPES, unlockedShapes);
        }

        class_2499 favoriteShapes = new class_2499();
        remorphed$favoriteShapes.forEach(shape -> {
            if (shape != null) {
                class_2487 entryTag = new class_2487();
                entryTag.method_10582("id", class_1299.method_5890(shape.getEntityType()).toString());
                entryTag.method_10569("variant", shape.getVariantData());
                favoriteShapes.add(entryTag);
            }
        });
        if (!favoriteShapes.isEmpty()) {
            tag.method_10566(FAVORITE_SHAPES, favoriteShapes);
        }

        class_2499 unlockedSkins = new class_2499();
        remorphed$unlockedSkins.forEach((skinId, killAmount) -> {
            if (killAmount > 0 && skinId != null) {
                class_2487 entryTag = new class_2487();
                entryTag.method_25927("uuid", skinId);
                entryTag.method_10569("killAmount", killAmount);
                unlockedSkins.add(entryTag);
            }
        });
        if (!unlockedSkins.isEmpty()) {
            tag.method_10566(UNLOCKED_SKINS, unlockedSkins);
        }

        class_2499 favoriteSkins = new class_2499();
        remorphed$favoriteSkins.forEach(skinId -> {
            if (skinId != null) {
                class_2487 entryTag = new class_2487();
                entryTag.method_25927("uuid", skinId);
                favoriteSkins.add(entryTag);
            }
        });
        if (!favoriteSkins.isEmpty()) {
            tag.method_10566(FAVORITE_SKINS, favoriteSkins);
        }

        class_2499 morphCounter = new class_2499();
        remorphed$ShapeMorphCounter.forEach((type, count) -> {
            if (count > 0 && type != null) {
                class_2487 entryTag = new class_2487();
                entryTag.method_10556("isSkin", false);
                entryTag.method_10582("id", class_1299.method_5890(type.getEntityType()).toString());
                entryTag.method_10569("variant", type.getVariantData());
                entryTag.method_10569("counter", count);
                morphCounter.add(entryTag);
            }
        });
        remorphed$SkinMorphCounter.forEach((skinId, count) -> {
            if (count > 0 && skinId != null) {
                class_2487 entryTag = new class_2487();
                entryTag.method_10556("isSkin", true);
                entryTag.method_25927("uuid", skinId);
                entryTag.method_10569("counter", count);
                morphCounter.add(entryTag);
            }
        });
        if (!morphCounter.isEmpty()) {
            tag.method_10566(MORPH_COUNTER, morphCounter);
        }

        return tag;
    }

    @SuppressWarnings("unchecked")
    @Unique
    public void remorphed$readData(@NotNull class_2487 tag) {
        remorphed$unlockedShapes.clear();
        remorphed$favoriteShapes.clear();
        remorphed$unlockedSkins.clear();
        remorphed$favoriteSkins.clear();
        remorphed$SkinMorphCounter.clear();
        remorphed$ShapeMorphCounter.clear();

        class_2499 unlockedShapes = tag.method_10554(UNLOCKED_SHAPES, class_2499.field_33260);
        unlockedShapes.forEach(entry -> {
            if (entry instanceof class_2487) {
                class_2960 typeId = class_2960.method_60654(((class_2487) entry).method_10558("id"));
                int typeVariantId = ((class_2487) entry).method_10550("variant");
                int killAmount = ((class_2487) entry).method_10550("killAmount");

                remorphed$unlockedShapes.put(ShapeType.from((class_1299<? extends class_1309>) class_7923.field_41177.method_10223(typeId).map(class_6880::comp_349).orElse(null), typeVariantId), killAmount);
            }
        });
        class_2499 favoriteShapes = tag.method_10554(FAVORITE_SHAPES, class_2499.field_33260);
        favoriteShapes.forEach(entry -> {
            if (entry instanceof class_2487) {
                class_2960 typeId = class_2960.method_60654(((class_2487) entry).method_10558("id"));
                int typeVariantId = ((class_2487) entry).method_10550("variant");

                remorphed$favoriteShapes.add(ShapeType.from((class_1299<? extends class_1309>) class_7923.field_41177.method_10223(typeId).map(class_6880::comp_349).orElse(null), typeVariantId));
            }
        });

        class_2499 unlockedSkins = tag.method_10554(UNLOCKED_SKINS, class_2499.field_33260);
        unlockedSkins.forEach(entry -> {
            if (entry instanceof class_2487) {
                UUID skinId = ((class_2487) entry).method_25926("uuid");
                int killAmount = ((class_2487) entry).method_10550("killAmount");
                remorphed$unlockedSkins.put(skinId, killAmount);
            }
        });
        class_2499 favoriteSkins = tag.method_10554(FAVORITE_SKINS, class_2499.field_33260);
        favoriteSkins.forEach(entry -> {
            if (entry instanceof class_2487) {
                UUID skinId = ((class_2487) entry).method_25926("uuid");

                remorphed$favoriteSkins.add(skinId);
            }
        });

        class_2499 morphCounter = tag.method_10554(MORPH_COUNTER, class_2499.field_33260);
        morphCounter.forEach(entry -> {
            boolean isSkin = ((class_2487) entry).method_10577("isSkin");
            int count = ((class_2487) entry).method_10550("counter");
            if (isSkin) {
                UUID skinId = ((class_2487) entry).method_25926("uuid");
                remorphed$SkinMorphCounter.put(skinId, count);
            } else {
                class_2960 typeId = class_2960.method_60654(((class_2487) entry).method_10558("id"));
                int typeVariantId = ((class_2487) entry).method_10550("variant");
                remorphed$ShapeMorphCounter.put(ShapeType.from((class_1299<? extends class_1309>) class_7923.field_41177.method_10223(typeId).map(class_6880::comp_349).orElse(null), typeVariantId), count);
            }
        });
    }

    @Unique
    @Override
    public Map<ShapeType<? extends class_1309>, Integer> remorphed$getUnlockedShapes() {
        return remorphed$unlockedShapes;
    }

    @Unique
    @Override
    public void remorphed$addKill(ShapeType<? extends class_1309> type) {
        remorphed$unlockedShapes.put(type, remorphed$getKills(type) + 1);
    }

    @Unique
    @Override
    public int remorphed$getKills(ShapeType<? extends class_1309> type) {
        if (Walkers.CONFIG.unlockEveryVariant) {
            int killAmount = 0;
            for (int i : remorphed$unlockedShapes.entrySet().stream().filter(entry -> entry.getKey().getEntityType().equals(type.getEntityType())).map(Map.Entry::getValue).toList()) {
                killAmount += i;
            }
            return killAmount;
        } else {
            return remorphed$unlockedShapes.getOrDefault(type, 0);
        }
    }

    @Unique
    @Override
    public Set<ShapeType<?>> remorphed$getFavoriteShapes() {
        return remorphed$favoriteShapes;
    }

    @Unique
    @Override
    public Map<UUID, Integer> remorphed$getUnlockedSkins() {
        return remorphed$unlockedSkins;
    }

    @Unique
    @Override
    public void remorphed$addKill(UUID skinId) {
        remorphed$unlockedSkins.put(skinId, remorphed$getKills(skinId) + 1);
    }

    @Unique
    @Override
    public int remorphed$getKills(UUID skinId) {
        return remorphed$unlockedSkins.getOrDefault(skinId, 0);
    }

    @Unique
    @Override
    public Set<UUID> remorphed$getFavoriteSkins() {
        return remorphed$favoriteSkins;
    }

    @Unique
    @Override
    public int remorphed$getCounter(ShapeType<? extends class_1309> type) {
        if (Walkers.CONFIG.unlockEveryVariant) {
            int counter = 0;
            for (int i : remorphed$ShapeMorphCounter.entrySet().stream().filter(entry -> entry.getKey().getEntityType().equals(type.getEntityType())).map(Map.Entry::getValue).toList()) {
                counter += i;
            }
            return counter;
        } else {
            return remorphed$ShapeMorphCounter.getOrDefault(type, 0);
        }
    }

    @Unique
    @Override
    public int remorphed$getCounter(UUID skinId) {
        return remorphed$SkinMorphCounter.getOrDefault(skinId, 0);
    }

    @Unique
    @Override
    public void remorphed$handleSwap(ShapeType<? extends class_1309> type) {
        if (((class_1657) (Object) this).method_7337()) {
            return;
        }

        int counter = remorphed$getCounter(type) + 1;
        int killValue = Remorphed.getKillValue(type.getEntityType());

        if (killValue > 0 && counter >= killValue) {
            // get current kill amount
            int k = remorphed$unlockedShapes.getOrDefault(type, 0);
            ShapeType<?> killType = type;

            // check the kill amount of other variants if current one is zero
            if (Walkers.CONFIG.unlockEveryVariant) {
                List<? extends ShapeType<?>> variants = ShapeType.getAllTypes(type.getEntityType());
                for (int i = 0; k <= 0 && i < variants.size(); i++) {
                    killType = variants.get(i);
                    k = remorphed$unlockedShapes.getOrDefault(killType, 0);
                }
            }

            // remove one kill
            if (k <= 1) {
                int k2 = remorphed$unlockedShapes.remove(killType);
            } else {
                remorphed$unlockedShapes.put(killType, k - 1);
            }

            // reset counter
            if (Walkers.CONFIG.unlockEveryVariant) {
                ShapeType<? extends class_1309> ctype;
                List<? extends ShapeType<?>> variants = ShapeType.getAllTypes(type.getEntityType());
                for (int i = 0; counter > 0 && i < variants.size(); i++) {
                    Integer c = remorphed$ShapeMorphCounter.remove(variants.get(i));
                    if (c != null) {
                        counter -= c;
                    }
                }
            } else {
                remorphed$ShapeMorphCounter.remove(type);
            }

            // check and remove 2nd Shape if necessary
            //noinspection ConstantValue
            if ((Object) this instanceof class_3222 serverPlayer && !Remorphed.canUseShape(serverPlayer, type)) {
                PlayerShapeChanger.change2ndShape(serverPlayer, null);
            }
        } else {
            // raise counter
            remorphed$ShapeMorphCounter.put(type, remorphed$ShapeMorphCounter.getOrDefault(type, 0) + 1);
        }
    }

    @Unique
    @Override
    public void remorphed$handleSwap(UUID skinId) {
        if (((class_1657) (Object) this).method_7337()) {
            return;
        }

        int counter = remorphed$SkinMorphCounter.getOrDefault(skinId, 0) + 1;
        counter++;
        int killValue = Remorphed.CONFIG.playerKillValue;
        if (killValue > 0 && counter >= killValue) {
            // reset counter
            remorphed$SkinMorphCounter.remove(skinId);
            // remove one kill
            int k = remorphed$getKills(skinId) - 1;
            if (k <= 0) {
                remorphed$unlockedSkins.remove(skinId);
            } else {
                remorphed$unlockedSkins.put(skinId, k);
            }
        } else {
            remorphed$SkinMorphCounter.put(skinId, counter);
        }
    }

    @Unique
    @Override
    public Map<ShapeType<?>, Integer> remorphed$getShapeCounter() {
        return remorphed$ShapeMorphCounter;
    }

    @Unique
    @Override
    public Map<UUID, Integer> remorphed$getSkinCounter() {
        return remorphed$SkinMorphCounter;
    }
}
