package tocraft.remorphed.impl;

import com.mojang.authlib.GameProfile;
import dev.tocraft.skinshifter.data.SkinPlayerData;
import tocraft.walkers.api.variant.ShapeType;

import java.util.*;
import java.util.stream.Collectors;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;

public class PlayerMorph {
    public static Map<ShapeType<? extends class_1309>, Integer> getUnlockedShapes(class_1657 player) {
        return ((RemorphedPlayerDataProvider) player).remorphed$getUnlockedShapes();
    }

    public static void addKill(class_1657 player, ShapeType<? extends class_1309> type) {
        ((RemorphedPlayerDataProvider) player).remorphed$addKill(type);
    }

    public static int getKills(class_1657 player, ShapeType<? extends class_1309> type) {
        return ((RemorphedPlayerDataProvider) player).remorphed$getKills(type);
    }

    public static int getKills(class_1657 player, class_1299<?> type) {
        return getUnlockedShapes(player).entrySet().stream().filter(e -> e.getKey() != null && type.equals(e.getKey().getEntityType())).map(Map.Entry::getValue).reduce(0, Integer::sum);
    }

    public static Set<ShapeType<?>> getFavoriteShapes(class_1657 player) {
        return ((RemorphedPlayerDataProvider) player).remorphed$getFavoriteShapes();
    }

    public static Map<UUID, Integer> getUnlockedSkinIds(class_1657 player) {
        return ((RemorphedPlayerDataProvider) player).remorphed$getUnlockedSkins();
    }

    public static void addPlayerKill(class_1657 player, UUID uuid) {
        ((RemorphedPlayerDataProvider) player).remorphed$addKill(uuid);
    }

    public static int getPlayerKills(class_1657 player, UUID uuid) {
        return ((RemorphedPlayerDataProvider) player).remorphed$getKills(uuid);
    }

    public static Set<GameProfile> getFavoriteSkins(class_1657 player) {
        return getFavoriteSkinIds(player).stream().map(p -> SkinPlayerData.getSkinProfile(p).getNow(Optional.empty()).orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static Set<UUID> getFavoriteSkinIds(class_1657 player) {
        return ((RemorphedPlayerDataProvider) player).remorphed$getFavoriteSkins();
    }

    public static void handleSwap(class_1657 player, ShapeType<? extends class_1309> type) {
        ((RemorphedPlayerDataProvider) player).remorphed$handleSwap(type);
    }

    public static void handleSwap(class_1657 player, UUID skinId) {
        ((RemorphedPlayerDataProvider) player).remorphed$handleSwap(skinId);
    }

    public static int getCounter(class_1657 player, ShapeType<? extends class_1309> type) {
        return ((RemorphedPlayerDataProvider) player).remorphed$getCounter(type);
    }

    public static int getCounter(class_1657 player, UUID skinId) {
        return ((RemorphedPlayerDataProvider) player).remorphed$getCounter(skinId);
    }

    public static Map<ShapeType<?>, Integer> getShapeCounter(class_1657 player) {
        return ((RemorphedPlayerDataProvider) player).remorphed$getShapeCounter();
    }

    public static Map<UUID, Integer> getSkinCounter(class_1657 player) {
        return ((RemorphedPlayerDataProvider) player).remorphed$getSkinCounter();
    }
}
