package tocraft.remorphed;

import com.mojang.authlib.GameProfile;
import dev.tocraft.skinshifter.data.SkinPlayerData;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4844;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tocraft.craftedcore.config.ConfigLoader;
import tocraft.craftedcore.event.common.CommandEvents;
import tocraft.craftedcore.event.common.EntityEvents;
import tocraft.craftedcore.event.common.PlayerEvents;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.craftedcore.platform.PlatformData;
import tocraft.craftedcore.platform.VersionChecker;
import tocraft.remorphed.command.RemorphedCommand;
import tocraft.remorphed.config.RemorphedConfig;
import tocraft.remorphed.handler.LivingDeathHandler;
import tocraft.remorphed.handler.PlayerRespawnHandler;
import tocraft.remorphed.handler.SwapShapeCallback;
import tocraft.remorphed.handler.UnlockShapeCallback;
import tocraft.remorphed.impl.PlayerMorph;
import tocraft.remorphed.network.NetworkHandler;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.events.ShapeEvents;
import tocraft.walkers.api.platform.ApiLevel;
import tocraft.walkers.api.variant.ShapeType;

import java.util.*;

public class Remorphed {
    @ApiStatus.Internal
    public static final Logger LOGGER = LoggerFactory.getLogger(Remorphed.class);
    public static final String MODID = "remorphed";
    public static final RemorphedConfig CONFIG = ConfigLoader.register(MODID);
    public static boolean displayVariantsInMenu = CONFIG.show_variants_by_default;
    public static boolean displayDataInMenu = CONFIG.show_traits_by_default;
    @ApiStatus.Internal
    public static final boolean foundSkinShifter = PlatformData.isModLoaded("skinshifter");

    public void initialize() {
        ShapeEvents.UNLOCK_SHAPE.register(new UnlockShapeCallback());
        ShapeEvents.SWAP_SHAPE.register(new SwapShapeCallback());
        if (!CONFIG.unlockFriendlyNormal) {
            ApiLevel.setApiLevel(ApiLevel.MORPHING_AND_VARIANTS_MENU_ONLY);
        }

        // add DarkShadow_2k to devs (for creating the special shape icon and concepts)
        //noinspection UnstableApiUsage
        Walkers.devs.add(UUID.fromString("74b6d9b3-c8c1-40db-ab82-ccc290d1aa03"));

        VersionChecker.registerModrinthChecker(MODID, "remorphed", class_2561.method_43470("Remorphed"));

        if (PlatformData.getEnv() == EnvType.CLIENT) new RemorphedClient().initialize();

        NetworkHandler.registerPacketReceiver();

        CommandEvents.REGISTRATION.register(new RemorphedCommand());
        EntityEvents.LIVING_DEATH.register(new LivingDeathHandler());
        PlayerEvents.PLAYER_RESPAWN.register(new PlayerRespawnHandler());

        // allow unlocking friendly mobs via the "normal" method
        Walkers.CONFIG.unlockOverridesCurrentShape = Remorphed.CONFIG.unlockFriendlyNormal;
        Walkers.CONFIG.save();

        // Sync favorites
        PlayerEvents.PLAYER_JOIN.register(NetworkHandler::sendFavoriteSync);
    }

    public static boolean canUseEveryShape(@NotNull class_1657 player) {
        return player.method_7337() && CONFIG.creativeUnlockAll;
    }

    public static boolean canUseShape(class_1657 player, ShapeType<?> type) {
        return canUseEveryShape(player) || !Remorphed.CONFIG.lockTransform && (type == null || Remorphed.getKillToUnlock(type.getEntityType()) <= 0 || PlayerMorph.getKills(player, type) >= Remorphed.getKillToUnlock(type.getEntityType()));
    }

    public static boolean canUseShape(class_1657 player, class_1299<?> type) {
        return canUseEveryShape(player) || !Remorphed.CONFIG.lockTransform && (type == null || Remorphed.getKillToUnlock(type) <= 0 || PlayerMorph.getKills(player, type) >= Remorphed.getKillToUnlock(type));
    }

    public static List<ShapeType<?>> getUnlockedShapes(class_1657 player) {
        if (canUseEveryShape(player)) {
            return ShapeType.getAllTypes(player.method_37908());
        } else if (Walkers.CONFIG.unlockEveryVariant) {
            List<ShapeType<?>> unlocked = new ArrayList<>();
            for (ShapeType<?> shapeType : ShapeType.getAllTypes(player.method_37908())) {
                if (!unlocked.contains(shapeType) && canUseShape(player, shapeType)) unlocked.add(shapeType);
            }
            return unlocked;
        } else {
            return new ArrayList<>(PlayerMorph.getUnlockedShapes(player).keySet().stream().filter(type -> canUseShape(player, type)).toList());
        }
    }

    @Contract("_ -> new")
    public static @NotNull List<GameProfile> getUnlockedSkins(class_1657 player) {
        return new ArrayList<>(PlayerMorph.getUnlockedSkinIds(player).keySet().stream().filter(skinId -> (PlayerMorph.getPlayerKills(player, skinId) >= CONFIG.killToUnlockPlayers || CONFIG.killToUnlockPlayers == 0) && CONFIG.killToUnlockPlayers != -1).map(id -> SkinPlayerData.getSkinProfile(id).getNow(Optional.empty()).orElse(null)).filter(Objects::nonNull).toList());
    }

    public static int getKillToUnlock(class_1299<?> type) {
        return Remorphed.CONFIG.killToUnlockByType.getOrDefault(class_1299.method_5890(type).toString(), Remorphed.CONFIG.killToUnlock);

    }

    public static int getKillValue(class_1299<?> type) {
        return Remorphed.CONFIG.killValueByType.getOrDefault(class_1299.method_5890(type).toString(), Remorphed.CONFIG.killValue);
    }

    public static void sync(class_3222 player) {
        sync(player, player);
    }

    public static void sync(class_3222 changed, class_3222 packetTarget) {
        class_2487 compoundTag = new class_2487();

        // serialize current shape data to tag if it exists
        Map<ShapeType<?>, Integer> unlockedShapes = PlayerMorph.getUnlockedShapes(changed);
        class_2499 shapesList = new class_2499();
        unlockedShapes.forEach((shape, killAmount) -> {
            if (killAmount > 0 && shape != null) {
                class_2487 compound = new class_2487();
                compound.method_10582("id", class_1299.method_5890(shape.getEntityType()).toString());
                compound.method_10569("variant", shape.getVariantData());
                compound.method_10569("killAmount", killAmount);
                shapesList.add(compound);
            }
        });
        if (!shapesList.isEmpty()) compoundTag.method_10566("UnlockedShapes", shapesList);

        Map<UUID, Integer> unlockedSkins = PlayerMorph.getUnlockedSkinIds(changed);
        class_2499 skinsList = new class_2499();
        unlockedSkins.forEach((skinId, killAmount) -> {
            if (killAmount > 0 && skinId != null) {
                class_2487 compound = new class_2487();
                compound.method_10539("uuid", class_4844.method_26275(skinId));
                compound.method_10569("killAmount", killAmount);
                skinsList.add(compound);
            }
        });
        if (!skinsList.isEmpty()) compoundTag.method_10566("UnlockedSkins", skinsList);

        class_2499 morphCounter = new class_2499();
        PlayerMorph.getShapeCounter(changed).forEach((type, count) -> {
            if (count > 0 && type != null) {
                class_2487 entryTag = new class_2487();
                entryTag.method_10556("isSkin", false);
                entryTag.method_10582("id", class_1299.method_5890(type.getEntityType()).toString());
                entryTag.method_10569("variant", type.getVariantData());
                entryTag.method_10569("counter", count);
                morphCounter.add(entryTag);
            }
        });
        PlayerMorph.getSkinCounter(changed).forEach((skinId, count) -> {
            if (count > 0 && skinId != null) {
                class_2487 entryTag = new class_2487();
                entryTag.method_10556("isSkin", true);
                entryTag.method_10539("uuid", class_4844.method_26275(skinId));
                entryTag.method_10569("counter", count);
                morphCounter.add(entryTag);
            }
        });
        if (!morphCounter.isEmpty()) {
            compoundTag.method_10566("MorphCounter", morphCounter);
        }

        compoundTag.method_10539("uuid", class_4844.method_26275(changed.method_5667()));
        ModernNetworking.sendToPlayer(packetTarget, NetworkHandler.UNLOCKED_SYNC, compoundTag);
    }

    @Contract("_ -> new")
    public static @NotNull class_2960 id(String name) {
        return class_2960.method_60655(MODID, name);
    }
}
