package tocraft.remorphed.screen.widget;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_490;
import net.minecraft.class_7919;
import tocraft.craftedcore.platform.PlayerProfile;
import tocraft.remorphed.impl.FakeClientPlayer;
import tocraft.remorphed.network.NetworkHandler;
import tocraft.remorphed.screen.RemorphedScreen;
import tocraft.walkers.impl.PlayerDataProvider;
import tocraft.walkers.network.impl.SwapPackets;
//#else
//$$ import com.mojang.blaze3d.vertex.PoseStack;
//#endif
//#if MC>1182
import org.joml.Quaternionf;
//#if MC>=1202
import org.joml.Vector3f;
//#endif
//#else
//$$ import net.minecraft.client.gui.screens.Screen;
//#endif

@Environment(EnvType.CLIENT)
public class SkinWidget extends ShapeWidget {
    private final PlayerProfile skin;
    private final FakeClientPlayer fakePlayer;
    private final int size;

    public SkinWidget(float x, float y, float width, float height, PlayerProfile skin, FakeClientPlayer fakePlayer, RemorphedScreen parent, boolean isFavorite, boolean isCurrent) {
        super(x, y, width, height, parent, isFavorite, isCurrent);
        this.size = (int) (25 * (1 / (Math.max(fakePlayer.method_17682(), fakePlayer.method_17681()))));
        this.skin = skin;
        this.fakePlayer = fakePlayer;
        //#if MC>1182
        method_47400(class_7919.method_47407(class_2561.method_43470(skin.name())));
        //#endif
    }

    @Override
    protected void sendFavoriteRequest(boolean isFavorite) {
        NetworkHandler.sendFavoriteRequest(skin, isFavorite);
    }

    @Override
    protected void sendSwap2ndShapeRequest() {
        NetworkHandler.sendSwapSkinRequest(skin);
        class_1657 player = class_310.method_1551().field_1724;
        if (player != null && ((PlayerDataProvider) player).walkers$getCurrentShape() != null) {
            SwapPackets.sendSwapRequest();
        }
    }

    @Override
    //#if MC>1194
    protected void renderShape(class_332 guiGraphics) {
    //#else
    //$$ protected void renderShape(PoseStack guiGraphics) {
    //#endif
        if (skin.skin() != null) {
            //#if MC>1201
            class_490.method_48472(guiGraphics, method_46426() + (float) this.method_25368() / 2, (int) (method_46427() + this.method_25364() * .75f), size, new Vector3f(), new Quaternionf().rotationXYZ(0.43633232F, (float) Math.PI, (float) Math.PI), null, fakePlayer);
            //#elseif MC>1182
            //$$ InventoryScreen.renderEntityInInventory(guiGraphics, getX() + this.getWidth() / 2, (int) (getY() + this.getHeight() * .75f), size, new Quaternionf().rotationXYZ((float) Math.PI, 0, 0), new Quaternionf().rotationXYZ(0.43633232F, (float) Math.PI, (float) Math.PI), fakePlayer);
            //#else
            //$$ InventoryScreen.renderEntityInInventory(x + this.getWidth() / 2, (int) (y + this.getHeight() * .75f), size, -10, -10, fakePlayer);
            //#endif
        }
    }
}
