package tocraft.remorphed.screen.widget;

import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4264;
import net.minecraft.class_6382;
import tocraft.craftedcore.patched.client.CGraphics;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.screen.RemorphedScreen;

public abstract class ShapeWidget extends class_4264 {
    private final RemorphedScreen parent;
    private boolean crashed = false;
    private boolean isFavorite;
    private final boolean isCurrent;

    public ShapeWidget(float x, float y, float width, float height, RemorphedScreen parent, boolean isFavorite, boolean isCurrent) {
        super((int) x, (int) y, (int) width, (int) height, class_2561.method_30163(""));
        this.parent = parent;
        this.isFavorite = isFavorite;
        this.isCurrent = isCurrent;
    }

    protected abstract void sendFavoriteRequest(boolean isFavorite);
    protected abstract void sendSwap2ndShapeRequest();
    //#if MC>1194
    protected abstract void renderShape(class_332 guiGraphics);
    //#else
    //$$ protected abstract void renderShape(PoseStack guiGraphics);
    //#endif

    protected void setCrashed() {
        this.crashed = true;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean bl = mouseX >= (double) this.method_46426() && mouseX < (double) (this.method_46426() + this.field_22758) && mouseY >= (double) this.method_46427() && mouseY < (double) (this.method_46427() + this.field_22759);
        if (bl && class_310.method_1551().field_1724 != null) {
            // switch to new shape
            if (button == 0 && !isCurrent) {
                // Update 2nd Shape
                sendSwap2ndShapeRequest();
                // close active screen handler
                parent.method_25419();
            }
            // Add to favorites
            else if (button == 1) {
                isFavorite = !isFavorite;
                sendFavoriteRequest(isFavorite);
            }
        }

        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    //#if MC>1194
    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
        //#elseif MC>1182
        //$$ public void renderWidget(PoseStack guiGraphics, int mouseX, int mouseY, float delta) {
        //#else
        //$$ public void renderButton(PoseStack guiGraphics, int mouseX, int mouseY, float delta) {
        //#endif
        if (!crashed) {
            renderShape(guiGraphics);

            // Render selected outline
            if (isCurrent) {
                CGraphics.blit(guiGraphics, Remorphed.id("textures/gui/selected.png"), method_46426(), method_46427(), method_25368(), method_25364(), 0, 0, 48, 32, 48, 32);
            }
            // Render favorite
            if (isFavorite) {
                CGraphics.blit(guiGraphics, Remorphed.id("textures/gui/favorite.png"), method_46426(), method_46427(), method_25368(), method_25364(), 0, 0, 48, 32, 48, 32);
            }
        }
    }

    @Override
    public void method_25306() {

    }

    //#if MC>1182
    @Override
    public void method_47399(class_6382 builder) {

    }
    //#else
    //$$ @Override
    //$$ public void updateNarration(NarrationElementOutput narrationElementOutput) {
    //$$
    //$$ }
    //$$ public int getX() {
    //$$     return x;
    //$$ }
    //$$ public int getY() {
    //$$     return y;
    //$$ }
    //#endif
}
