package tocraft.remorphed.screen.widget;

import dev.tocraft.skinshifter.SkinShifter;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4264;
import net.minecraft.class_6382;
import net.minecraft.class_742;
import net.minecraft.class_7919;
import tocraft.craftedcore.patched.client.CGraphics;
import tocraft.craftedcore.platform.PlayerProfile;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.network.NetworkHandler;
import tocraft.remorphed.screen.RemorphedScreen;
import tocraft.walkers.impl.PlayerDataProvider;
import tocraft.walkers.network.impl.SwapPackets;
import java.util.concurrent.CompletableFuture;

@Environment(EnvType.CLIENT)
public class PlayerWidget extends class_4264 {
    private final RemorphedScreen parent;

    public PlayerWidget(int x, int y, int width, int height, RemorphedScreen parent) {
        super(x, y, width, height, class_2561.method_30163(""));
        this.parent = parent;
        //#if MC>1182
        method_47400(class_7919.method_47407(class_2561.method_43471("remorphed.player_icon")));
        //#endif
    }

    @Override
    //#if MC>1194
    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float delta) {
    //#elseif MC>1182
    //$$ public void renderWidget(PoseStack guiGraphics, int mouseX, int mouseY, float delta) {
    //#else
    //$$ public void renderButton(PoseStack guiGraphics, int mouseX, int mouseY, float delta) {
    //#endif
        class_742 player = class_310.method_1551().field_1724;
            if (player != null) {
            //#if MC>1201
            class_2960 skinLocation = player.method_52814().comp_1626();
            //#else
            //$$ ResourceLocation skinLocation = player.getSkinTextureLocation();
            //#endif
            if (Remorphed.foundSkinShifter && SkinShifter.getCurrentSkin(player) != null) {
                // still render own skin as icon when in another skin
                PlayerProfile playerProfile = PlayerProfile.getCachedProfile(player.method_5667());
                if (playerProfile != null && playerProfile.skin() != null) {
                    skinLocation = playerProfile.getSkinId();
                } else {
                    // cache profile asynchronous
                    CompletableFuture.runAsync(() -> PlayerProfile.ofId(player.method_5667()));
                }
            }

            CGraphics.blit(guiGraphics, skinLocation, method_46426(), method_46427(), method_25368(), method_25364(), 8.0f, 8, 8, 8, 64, 64);
                CGraphics.blit(guiGraphics, skinLocation, method_46426(), method_46427(), method_25368(), method_25364(), 40.0f, 8, 8, 8, 64, 64);
        } else {
            //#if MC>1182
            super.method_48579(guiGraphics, mouseX, mouseY, delta);
            //#else
            //$$ super.renderButton(guiGraphics, mouseX, mouseY, delta);
            //#endif
        }
        //#if MC<=1182
        //$$ if (isHoveredOrFocused()) {
        //$$     renderToolTip(guiGraphics, mouseX, mouseY);
        //$$ }
        //#endif
    }

    @Override
    public void method_25306() {
        if (class_310.method_1551().field_1724 != null) {
            if (((PlayerDataProvider) class_310.method_1551().field_1724).walkers$getCurrentShape() != null) {
                SwapPackets.sendSwapRequest();
                parent.method_25419();
            }
            if (Remorphed.foundSkinShifter && SkinShifter.getCurrentSkin(class_310.method_1551().field_1724) != class_310.method_1551().field_1724.method_5667()) {
                NetworkHandler.sendResetSkinPacket();
                parent.method_25419();
            }
        }
    }

    //#if MC>1182
    @Override
    public void method_47399(class_6382 builder) {
    
    }
    //#else
    //$$ @Override
    //$$ public void updateNarration(NarrationElementOutput narrationElementOutput) {
    //$$
    //$$ }
    //$$
    //$$ public int getX() {
    //$$     return x;
    //$$ }
    //$$ public int getY() {
    //$$     return y;
    //$$ }
    //$$
    //$$ @Override
    //$$ public void renderToolTip(PoseStack poseStack, int mouseX, int mouseY) {
    //$$     Screen currentScreen = Minecraft.getInstance().screen;
    //$$
    //$$     if (currentScreen != null) {
    //$$         currentScreen.renderTooltip(poseStack,  TComponent.translatable("remorphed.player_icon"), mouseX, mouseY);
    //$$     }
    //$$ }
    //#endif
}
