package tocraft.remorphed.screen.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_490;
import net.minecraft.class_7919;
import net.minecraft.class_898;
//#if MC>1182
import org.joml.Quaternionf;
import org.joml.Vector3f;
//#else
//$$ import net.minecraft.client.gui.screens.Screen;
//#endif
import tocraft.craftedcore.patched.client.CGraphics;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.network.NetworkHandler;
import tocraft.remorphed.screen.RemorphedScreen;
import tocraft.walkers.api.variant.ShapeType;
import tocraft.walkers.traits.ShapeTrait;
import tocraft.walkers.traits.TraitRegistry;

import java.util.ArrayList;
import java.util.List;

@Environment(EnvType.CLIENT)
public class EntityWidget<T extends class_1309> extends ShapeWidget {

    private final ShapeType<T> type;
    private final T entity;
    private final int size;

    public EntityWidget(float x, float y, float width, float height, ShapeType<T> type, T entity, RemorphedScreen parent, boolean isFavorite, boolean current) {
        super((int) x, (int) y, (int) width, (int) height, parent, isFavorite, current); // int x, int y, int width, int height, message
        this.size = (int) (25 * (1 / (Math.max(entity.method_17682(), entity.method_17681()))));
        this.type = type;
        this.entity = entity;
        entity.method_5834(true);
        //#if MC>1182
        method_47400(class_7919.method_47407(ShapeType.createTooltipText(entity)));
        //#endif
    }

    @Override
    protected void sendFavoriteRequest(boolean isFavorite) {
        NetworkHandler.sendFavoriteRequest(type, isFavorite);
    }

    @Override
    protected void sendSwap2ndShapeRequest() {
        NetworkHandler.sendSwap2ndShapeRequest(type);
    }

    @Override
    //#if MC>1194
    protected void renderShape(class_332 guiGraphics) {
    //#else
    //$$ protected void renderShape(PoseStack guiGraphics) {
    //#endif
        if (Remorphed.displayTraitsInMenu) {
            // Render Trait Icons first
            int blitOffset = 0;
            int rowIndex = 0;
            List<class_2960> renderedTraits = new ArrayList<>();
            for (ShapeTrait<T> trait : TraitRegistry.getAll(entity)) {
                if (trait != null && trait.getIcon() != null && (!renderedTraits.contains(trait.getId()) || trait.iconMightDiffer())) {
                    CGraphics.blit(guiGraphics, method_46426() + rowIndex, method_46427() + blitOffset, 0, 18, 18, trait.getIcon());
                    // prevent infinite traits to be rendered
                    if (blitOffset >= method_25364() - 18) {
                        rowIndex += 18;
                        blitOffset = 0;
                    } else {
                        blitOffset += 18;
                    }
                    if (rowIndex >= method_25368() - 18) {
                        break;
                    }
                    renderedTraits.add(trait.getId());
                }
            }
        }

        // Some entities (namely Aether mobs) crash when rendered in a GUI.
        // Unsure as to the cause, but this try/catch should prevent the game from entirely dipping out.
        try {
            // ARGH
            //#if MC>1201
            class_490.method_48472(guiGraphics, method_46426() + (float) this.method_25368() / 2, (int) (method_46427() + this.method_25364() * .75f), size, new Vector3f(), new Quaternionf().rotationXYZ(0.43633232F, (float) Math.PI, (float) Math.PI), null, entity);
            //#elseif MC>1182
            //$$ InventoryScreen.renderEntityInInventory(guiGraphics, getX() + this.getWidth() / 2, (int) (getY() + this.getHeight() * .75f), size, new Quaternionf().rotationXYZ((float) Math.PI, 0, 0), new Quaternionf().rotationXYZ(0.43633232F, (float) Math.PI, (float) Math.PI), entity);
            //#else
            //$$ InventoryScreen.renderEntityInInventory(x + this.getWidth() / 2, (int) (y + this.getHeight() * .75f), size, -10, -10, entity);
            //#endif
        } catch (Exception e) {
            Remorphed.LOGGER.error("Error while rendering {}", ShapeType.createTooltipText(entity).getString(), e);
            setCrashed();
            class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
            immediate.method_22993();
            class_898 entityRenderDispatcher = class_310.method_1551().method_1561();
            entityRenderDispatcher.method_3948(true);
            //#if MC>=1205
            RenderSystem.getModelViewStack().popMatrix();
            //#else
            //$$ RenderSystem.getModelViewStack().popPose();
            //#endif
            class_308.method_24211();
        }
    }

    //#if MC<=1184
    //$$ @Override
    //$$ public void renderToolTip(PoseStack poseStack, int mouseX, int mouseY) {
    //$$     Screen currentScreen = Minecraft.getInstance().screen;
    //$$
    //$$     if (currentScreen != null) {
    //$$         currentScreen.renderTooltip(poseStack, ShapeType.createTooltipText(entity), mouseX, mouseY);
    //$$     }
    //$$ }
    //#endif
}
