package tocraft.remorphed.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.tocraft.skinshifter.SkinShifter;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import net.minecraft.class_7919;
import tocraft.craftedcore.patched.TComponent;
import tocraft.craftedcore.platform.PlayerProfile;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.impl.FakeClientPlayer;
import tocraft.remorphed.impl.PlayerMorph;
import tocraft.remorphed.mixin.accessor.ScreenAccessor;
import tocraft.remorphed.screen.widget.*;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.variant.ShapeType;

import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

@SuppressWarnings({"DataFlowIssue", "SequencedCollectionMethodCanBeUsed"})
@Environment(EnvType.CLIENT)
public class RemorphedScreen extends class_437 {
    private final List<ShapeType<?>> unlockedShapes = new CopyOnWriteArrayList<>();
    private final List<PlayerProfile> unlockedSkins = new CopyOnWriteArrayList<>();
    private final Map<ShapeType<?>, class_1308> renderEntities = new ConcurrentHashMap<>();
    private final Map<PlayerProfile, FakeClientPlayer> renderPlayers = new ConcurrentHashMap<>();
    private final List<ShapeWidget> shapeWidgets = new CopyOnWriteArrayList<>();
    private final SearchWidget searchBar = createSearchBar();
    private final class_4185 helpButton = createHelpButton();
    private final class_4185 variantsButton = createVariantsButton();
    private final class_4185 traitsButton = createTraitsButton();
    private final PlayerWidget playerButton = createPlayerButton();
    private final SpecialShapeWidget specialShapeButton = createSpecialShapeButton();
    private String lastSearchContents = "";

    public RemorphedScreen() {
        super(TComponent.literal(""));
        super.method_25423(class_310.method_1551(), class_310.method_1551().method_22683().method_4486(), class_310.method_1551().method_22683().method_4502());
    }

    @Override
    public void method_25426() {
        // don't initialize if the player is null
        if (field_22787 == null) return;
        if (field_22787.field_1724 == null) {
            this.method_25419();
            return;
        }

        method_37063(searchBar);
        method_37063(helpButton);
        method_37063(variantsButton);
        method_37063(traitsButton);
        method_37063(playerButton);
        if (Walkers.hasSpecialShape(field_22787.field_1724.method_5667())) {
            method_37063(specialShapeButton);
        }

        CompletableFuture.runAsync(() ->  {
            populateUnlockedRenderEntities(field_22787.field_1724);
            ShapeType<? extends class_1309> currentShape = ShapeType.from(PlayerShape.getCurrentShape(field_22787.field_1724));

            // handle favorites
            unlockedShapes.sort((first, second) -> {
                if (Objects.equals(first, currentShape)) {
                    return -1;
                } else if (Objects.equals(second, currentShape)) {
                    return 1;
                } else {
                    boolean firstIsFav = PlayerMorph.getFavoriteShapes(field_22787.field_1724).contains(first);
                    boolean secondIsFav = PlayerMorph.getFavoriteShapes(field_22787.field_1724).contains(second);
                    if (firstIsFav == secondIsFav) {
                        return 0;
                    }
                    else if (firstIsFav) {
                        return -1;
                    }
                    else {
                        return 1;
                    }
                }
            });

            // filter unlocked
            if (!Remorphed.displayVariantsInMenu) {
                List<ShapeType<?>> newUnlocked = new ArrayList<>();
                for (ShapeType<?> shapeType : unlockedShapes) {
                    if (shapeType.equals(currentShape) || !newUnlocked.stream().map(ShapeType::getEntityType).toList().contains(shapeType.getEntityType())) {
                        newUnlocked.add(shapeType);
                    }
                }

                unlockedShapes.clear();
                unlockedShapes.addAll(newUnlocked);
            }
            
            if (Remorphed.foundSkinShifter) {
                populateUnlockedRenderPlayers(field_22787.field_1724);
                UUID currentSkin = SkinShifter.getCurrentSkin(field_22787.field_1724);

                unlockedSkins.sort((first, second) -> {
                    if (Objects.equals(first.id(), currentSkin) && currentShape != null) {
                        return -1;
                    } else if (Objects.equals(second.id(), currentSkin) && currentShape != null) {
                        return 1;
                    } else {
                        boolean firstIsFav = PlayerMorph.getFavoriteSkinIds(field_22787.field_1724).contains(first.id());
                        boolean secondIsFav = PlayerMorph.getFavoriteSkinIds(field_22787.field_1724).contains(second.id());
                        if (firstIsFav == secondIsFav) {
                            return first.name().compareTo(second.name());
                        }
                        else if (firstIsFav) {
                            return -1;
                        }
                        else {
                            return 1;
                        }
                    }
                });
            }

            populateShapeWidgets(unlockedShapes, unlockedSkins);

            // implement search handler
            searchBar.method_1863(text -> {
                method_25395(searchBar);

                // Only re-filter if the text contents changed
                if (!lastSearchContents.equals(text)) {
                    ((ScreenAccessor) this).getSelectables().removeIf(button -> button instanceof EntityWidget);
                    method_25396().removeIf(button -> button instanceof EntityWidget);

                    List<ShapeType<?>> filteredShapes = unlockedShapes
                            .stream()
                            .filter(type -> text.isEmpty() || ShapeType.createTooltipText(renderEntities.get(type)).getString().toUpperCase().contains(text.toUpperCase()) || class_1299.method_5890(type.getEntityType()).toString().toUpperCase().contains(text.toUpperCase()))
                            .toList();
                    List<PlayerProfile> filteredSkins = unlockedSkins
                            .stream()
                            .filter(skin -> text.isEmpty() || skin.name().toUpperCase().contains(text.toUpperCase()) || skin.id().toString().contains(text.toUpperCase()))
                            .toList();

                    populateShapeWidgets(filteredShapes, filteredSkins);
                }

                lastSearchContents = text;
            });
        });
    }

    @Override
    //#if MC>1194
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
    //#else
    //$$ public void render(PoseStack context, int mouseX, int mouseY, float delta) {
    //#endif
        //#if MC>1201
        method_52752(context);
        //#else
        //$$ renderBackground(context);
        //#endif

        searchBar.method_25394(context, mouseX, mouseY, delta);
        helpButton.method_25394(context, mouseX, mouseY, delta);
        variantsButton.method_25394(context, mouseX, mouseY, delta);
        traitsButton.method_25394(context, mouseX, mouseY, delta);
        playerButton.method_25394(context, mouseX, mouseY, delta);
        if (Walkers.hasSpecialShape(field_22787.field_1724.method_5667())) {
            specialShapeButton.method_25394(context, mouseX, mouseY, delta);
        }

        double scaledFactor = this.field_22787.method_22683().method_4495();
        int top = 35;

        //#if MC>1194
        context.method_51448().method_22903();
        //#else
        //$$ context.pushPose();
        //#endif
        RenderSystem.enableScissor(
                (int) ((double) 0 * scaledFactor),
                (int) ((double) 0 * scaledFactor),
                (int) ((double) field_22789 * scaledFactor),
                (int) ((double) (this.field_22790 - top) * scaledFactor));

        for (ShapeWidget widget : shapeWidgets) {
            if (widget.method_46427() + widget.method_25364() > top && widget.method_46427() < getWindow().method_4502()) {
                widget.method_25394(context, mouseX, mouseY, delta);
            }
        }

        RenderSystem.disableScissor();

        //#if MC>1194
        context.method_51448().method_22909();
        //#else
        //$$ context.popPose();
        //#endif
    }

    @Override
    //#if MC>1201
    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
    //#else
    //$$ public boolean mouseScrolled(double mouseX, double mouseY, double scrollY) {
    //#endif
        if (!shapeWidgets.isEmpty()) {
            float firstPos = shapeWidgets.get(0).method_46427();
            ShapeWidget lastWidget = shapeWidgets.get(shapeWidgets.size() - 1);

            // Top section should always have mobs, prevent scrolling the entire list down the screen
            if ((scrollY >= 0 && firstPos >= 35) || (scrollY <= 0 && lastWidget.method_46427() <= getWindow().method_4502() - lastWidget.method_25364())) {
                return false;
            }

            for (class_6379 button : ((ScreenAccessor) this).getSelectables()) {
                if (button instanceof ShapeWidget widget) {
                    //#if MC>1182
                    widget.method_48229(widget.method_46426(), (int) (widget.method_46427() + scrollY * 10));
                    //#else
                    //$$ widget.y += (int) (scrollY * 10);
                    //#endif
                }
            }
        }

        return false;
    }

    @SuppressWarnings("unchecked")
    private void populateShapeWidgets(List<ShapeType<?>> rendered, List<PlayerProfile> skinProfiles) {
        shapeWidgets.clear();
        // add widget for each entity to be rendered
        int x = 15;
        int y = 35;
        int rows = (int) Math.ceil((rendered.size() + skinProfiles.size()) / 7f);

        ShapeType<class_1309> currentType = ShapeType.from(PlayerShape.getCurrentShape(field_22787.field_1724));

        for (int yIndex = 0; yIndex <= rows; yIndex++) {
            for (int xIndex = 0; xIndex < 7; xIndex++) {
                int listIndex = yIndex * 7 + xIndex;

                if (Remorphed.foundSkinShifter && listIndex < skinProfiles.size()) {
                    PlayerProfile skinProfile = skinProfiles.get(listIndex);
                    FakeClientPlayer fakePlayer = renderPlayers.get(skinProfile);
                    if (fakePlayer != null) {
                        SkinWidget skinWidget = new SkinWidget(
                                (getWindow().method_4486() - 27) / 7f * xIndex + x,
                                getWindow().method_4502() / 5f * yIndex + y,
                                (getWindow().method_4486() - 27) / 7f,
                                getWindow().method_4502() / 5f,
                                skinProfile,
                                new FakeClientPlayer(field_22787.field_1687, skinProfile),
                                this,
                                PlayerMorph.getFavoriteSkins(field_22787.field_1724).contains(skinProfile),
                                Objects.equals(SkinShifter.getCurrentSkin(field_22787.field_1724), skinProfile.id()) && currentType == null
                        );

                        method_37063(skinWidget);
                        shapeWidgets.add(skinWidget);
                    } else {
                        Remorphed.LOGGER.error("invalid skin profile: {}", skinProfile);
                    }
                }
                else if (listIndex < skinProfiles.size() + rendered.size()) {
                    ShapeType<?> type = rendered.get(listIndex - skinProfiles.size());
                    class_1308 entity = renderEntities.get(type);
                    if (entity != null) {
                        EntityWidget<?> entityWidget = new EntityWidget<>(
                                (getWindow().method_4486() - 27) / 7f * xIndex + x,
                                getWindow().method_4502() / 5f * yIndex + y,
                                (getWindow().method_4486() - 27) / 7f,
                                getWindow().method_4502() / 5f,
                                (ShapeType<class_1308>) type,
                                entity,
                                this,
                                PlayerMorph.getFavoriteShapes(field_22787.field_1724).contains(type),
                                type.equals(currentType)
                        );

                        method_37063(entityWidget);
                        shapeWidgets.add(entityWidget);
                    } else {
                        Remorphed.LOGGER.error("invalid shape type: {}", type.getEntityType().method_5882());
                    }
                }
            }
        }
    }

    public synchronized void populateUnlockedRenderEntities(class_1657 player) {
        unlockedShapes.clear();
        renderEntities.clear();
        List<ShapeType<?>> validUnlocked = Remorphed.getUnlockedShapes(player);
        for (ShapeType<?> type : validUnlocked) {
            class_1297 entity = type.create(class_310.method_1551().field_1687);
            if (entity instanceof class_1308 living) {
                unlockedShapes.add(type);
                renderEntities.put(type, living);
            }
        }

        Remorphed.LOGGER.info("Loaded {} entities for rendering", unlockedShapes.size());
    }

    public synchronized void populateUnlockedRenderPlayers(class_1657 player) {
        unlockedSkins.clear();
        renderPlayers.clear();
        List<PlayerProfile> validUnlocked = Remorphed.getUnlockedSkins(player);
        for (PlayerProfile profile : validUnlocked) {
            if (profile.id() != player.method_5667()) {
                FakeClientPlayer entity = new FakeClientPlayer(field_22787.field_1687, profile);
                unlockedSkins.add(profile);
                renderPlayers.put(profile, entity);
            }
        }

        Remorphed.LOGGER.info("Loaded {} players for rendering", unlockedSkins.size());
    }

    private SearchWidget createSearchBar() {
        return new SearchWidget(
                getWindow().method_4486() / 2f - (getWindow().method_4486() / 4f / 2) - 5,
                5,
                getWindow().method_4486() / 4f,
                20f);
    }

    //#if MC>1182
    private class_4185 createHelpButton() {
        class_4185.class_7840 helpButton = class_4185.method_46430(class_2561.method_30163("?"), (widget) -> class_310.method_1551().method_1507(new RemorphedHelpScreen()));
    
        int xOffset = Walkers.hasSpecialShape(class_310.method_1551().field_1724.method_5667()) ? 30 : 0;
    
        helpButton.method_46433((int) (getWindow().method_4486() / 2f + (getWindow().method_4486() / 8f) + 35 + xOffset), 5);
        helpButton.method_46437(20, 20);
        helpButton.method_46436(class_7919.method_47407(class_2561.method_43471(Remorphed.MODID + ".help")));
        return helpButton.method_46431();
    }
    
    private class_4185 createVariantsButton() {
        class_4185.class_7840 variantsButton = class_4185.method_46430(class_2561.method_43471("remorphed.display_variants"), (widget) -> {
            Remorphed.displayVariantsInMenu = !Remorphed.displayVariantsInMenu;
            class_310.method_1551().method_1507(new RemorphedScreen());
        });
    
        variantsButton.method_46433((int) (getWindow().method_4486() / 2f - (getWindow().method_4486() / 4f / 2) - 110), 5);
        variantsButton.method_46437(100, 20);
        variantsButton.method_46436(class_7919.method_47407(class_2561.method_43471(Remorphed.MODID + ".variants")));
    
        return variantsButton.method_46431();
    }
    
    private class_4185 createTraitsButton() {
        class_4185.class_7840 traitButton = class_4185.method_46430(class_2561.method_43471("remorphed.show_traits"), (widget) -> Remorphed.displayTraitsInMenu = !Remorphed.displayTraitsInMenu);
        int xOffset = Walkers.hasSpecialShape(class_310.method_1551().field_1724.method_5667()) ? 30 : 0;
    
        int xPos = (int) (getWindow().method_4486() / 2f + (getWindow().method_4486() / 8f) + 65 + xOffset);
        traitButton.method_46433(xPos, 5);
        traitButton.method_46437(Math.min(50, getWindow().method_4486() - xPos), 20);
        traitButton.method_46436(class_7919.method_47407(class_2561.method_43471(Remorphed.MODID + ".traits")));
    
        return traitButton.method_46431();
    }
    //#else
    //$$ private Button createHelpButton() {
    //$$     int xOffset = Walkers.hasSpecialShape(Minecraft.getInstance().player.getUUID()) ? 30 : 0;
    //$$     return new Button((int) (getWindow().getGuiScaledWidth() / 2f + (getWindow().getGuiScaledWidth() / 8f) + 35 + xOffset), 5, 20, 20, Component.nullToEmpty("?"), (widget) -> Minecraft.getInstance().setScreen(new RemorphedHelpScreen()));
    //$$ }
    //$$
    //$$ private Button createVariantsButton() {
    //$$     return new Button((int) (getWindow().getGuiScaledWidth() / 2f - (getWindow().getGuiScaledWidth() / 4f / 2) - 110), 5, 100, 20,  TComponent.translatable("remorphed.display_variants"), (widget) -> {
    //$$         Remorphed.displayVariantsInMenu = !Remorphed.displayVariantsInMenu;
    //$$         Minecraft.getInstance().setScreen(new RemorphedScreen());
    //$$     });
    //$$ }
    //$$
    //$$ private Button createTraitsButton() {
    //$$     int xOffset = Walkers.hasSpecialShape(Minecraft.getInstance().player.getUUID()) ? 30 : 0;
    //$$     int xPos = (int) (getWindow().getGuiScaledWidth() / 2f + (getWindow().getGuiScaledWidth() / 8f) + 65 + xOffset);
    //$$     return new Button(xPos, 5, Math.min(50, getWindow().getGuiScaledWidth() - xPos), 20,  TComponent.translatable("remorphed.show_traits"), (widget) -> {
    //$$         Remorphed.displayTraitsInMenu = !Remorphed.displayTraitsInMenu;
    //$$     });
    //$$ }
    //#endif

    private PlayerWidget createPlayerButton() {
        return new PlayerWidget(
                (int) (getWindow().method_4486() / 2f + (getWindow().method_4486() / 8f) + 5),
                5,
                20,
                20,
                this);
    }

    private SpecialShapeWidget createSpecialShapeButton() {
        return new SpecialShapeWidget(
                (int) (getWindow().method_4486() / 2f + (getWindow().method_4486() / 8f) + 35),
                5,
                20,
                20,
                this);
    }

    private class_1041 getWindow() {
        return class_310.method_1551().method_22683();
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (mouseY < 35) {
            return searchBar.method_25402(mouseX, mouseY, button) || helpButton.method_25402(mouseX, mouseY, button) || variantsButton.method_25402(mouseX, mouseY, button) || traitsButton.method_25402(mouseX, mouseY, button) || playerButton.method_25402(mouseX, mouseY, button) || specialShapeButton.method_25402(mouseX, mouseY, button);
        } else {
            for (ShapeWidget shapeWidget : shapeWidgets) {
                if (shapeWidget.method_25402(mouseX, mouseY, button)) {
                    this.method_25395(shapeWidget);
                    return true;
                }
            }
        }
        return false;
    }
}
