package tocraft.remorphed.network;

import dev.tocraft.skinshifter.SkinShifter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.craftedcore.patched.CEntity;
import tocraft.craftedcore.patched.Identifier;
import tocraft.craftedcore.patched.TComponent;
import tocraft.craftedcore.platform.PlayerProfile;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.impl.PlayerMorph;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.PlayerShapeChanger;
import tocraft.walkers.api.variant.ShapeType;

import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class NetworkHandler {
    public static final class_2960 MORPH_REQUEST = Remorphed.id("morph_request");
    public static final class_2960 UNLOCKED_SYNC = Remorphed.id("unlocked_sync");
    public static final class_2960 FAVORITE_SYNC = Remorphed.id("favorite_sync");
    public static final class_2960 FAVORITE_UPDATE = Remorphed.id("favorite_update");
    public static final class_2960 RESET_SKIN = Remorphed.id("reset_skin");

    public static void registerPacketReceiver() {
        ModernNetworking.registerReceiver(ModernNetworking.Side.C2S, NetworkHandler.MORPH_REQUEST, NetworkHandler::handleMorphRequestPacket);
        ModernNetworking.registerReceiver(ModernNetworking.Side.C2S, FAVORITE_UPDATE, NetworkHandler::handleFavoriteRequestPacket);
        ModernNetworking.registerReceiver(ModernNetworking.Side.C2S, NetworkHandler.RESET_SKIN, NetworkHandler::handleResetSkinPacket);

        //#if MC>=1205
        ModernNetworking.registerType(UNLOCKED_SYNC);
        ModernNetworking.registerType(FAVORITE_SYNC);
        //#endif
    }

    private static void handleResetSkinPacket(ModernNetworking.Context context, class_2487 data) {
        if (Remorphed.foundSkinShifter) {
            SkinShifter.setSkin((class_3222) context.getPlayer(), null);
        }
    }

    public static void sendResetSkinPacket() {
        ModernNetworking.sendToServer(RESET_SKIN, new class_2487());
    }

    public static <T extends class_1309> void sendSwap2ndShapeRequest(@NotNull ShapeType<T> type) {
        class_2487 compound = new class_2487();
        compound.method_10582("id", Walkers.getEntityTypeRegistry().method_10221(type.getEntityType()).toString());
        compound.method_10569("variant", type.getVariantData());

        ModernNetworking.sendToServer(NetworkHandler.MORPH_REQUEST, compound);
    }

    public static <T extends class_1309> void sendSwapSkinRequest(@NotNull PlayerProfile playerProfile) {
        class_2487 compound = new class_2487();
        compound.method_25927("playerUUID", playerProfile.id());

        ModernNetworking.sendToServer(NetworkHandler.MORPH_REQUEST, compound);
    }

    @SuppressWarnings({"DataFlowIssue", "unchecked"})
    private static void handleMorphRequestPacket(ModernNetworking.Context context, class_2487 compound) {
        context.getPlayer().method_5682().execute(() -> {
            // check if player is blacklisted
            if (Walkers.CONFIG.playerUUIDBlacklist.contains(context.getPlayer().method_5667())) {
                context.getPlayer().method_7353(TComponent.translatable("walkers.player_blacklisted"), true);
                return;
            }

            if (compound.method_10545("playerUUID") && Remorphed.foundSkinShifter) {
                UUID targetSkinUUID = compound.method_25926("playerUUID");
                SkinShifter.setSkin((class_3222) context.getPlayer(), targetSkinUUID);
            } else {
                class_2960 typeId = Identifier.parse(compound.method_10558("id"));
                int typeVariant = compound.method_10550("variant");

                class_1299<? extends class_1309> eType = (class_1299<? extends class_1309>) Walkers.getEntityTypeRegistry().method_10223(typeId);

                // make the default ShapeType null, doing it this way, it's ensured that invalid 2ndShapes won't cause crashes.
                @Nullable
                ShapeType<? extends class_1309> type = ShapeType.from(eType, typeVariant);
                // update Player
                boolean result = PlayerShapeChanger.change2ndShape((class_3222) context.getPlayer(), type);
                if (result && type != null)
                    PlayerShape.updateShapes((class_3222) context.getPlayer(), type.create(CEntity.level(context.getPlayer())));

                // Refresh player dimensions
                context.getPlayer().method_18382();
            }
        });
    }

    public static void sendFavoriteSync(class_3222 player) {
        Set<ShapeType<?>> favoriteShapes = PlayerMorph.getFavoriteShapes(player);
        Set<UUID> favoriteSkins = PlayerMorph.getFavoriteSkinIds(player);
        class_2487 tag = new class_2487();
        class_2499 shapeIdList = new class_2499();
        class_2499 skinIdList = new class_2499();
        favoriteShapes.forEach(type -> shapeIdList.add(type.writeCompound()));
        favoriteSkins.forEach(skin -> skinIdList.add(class_2512.method_25929(skin)));
        tag.method_10566("FavoriteShapes", shapeIdList);
        tag.method_10566("FavoriteSkins", skinIdList);

        // Create & send packet with NBT
        ModernNetworking.sendToPlayer(player, NetworkHandler.FAVORITE_SYNC, tag);
    }

    public static void sendFavoriteRequest(ShapeType<? extends class_1309> type, boolean favorite) {
        class_2487 packet = new class_2487();
        packet.method_10582("id", Walkers.getEntityTypeRegistry().method_10221(type.getEntityType()).toString());
        packet.method_10569("variant", type.getVariantData());
        packet.method_10556("favorite", favorite);
        ModernNetworking.sendToServer(FAVORITE_UPDATE, packet);
    }

    public static void sendFavoriteRequest(PlayerProfile playerProfile, boolean favorite) {
        class_2487 packet = new class_2487();
        packet.method_25927("playerUUID", playerProfile.id());
        packet.method_10556("favorite", favorite);
        ModernNetworking.sendToServer(FAVORITE_UPDATE, packet);
    }

    @SuppressWarnings({"unchecked", "DataFlowIssue"})
    private static void handleFavoriteRequestPacket(ModernNetworking.Context context, class_2487 packet) {
        boolean favorite = packet.method_10577("favorite");

        if (packet.method_10545("playerUUID")) {
            UUID skinId = packet.method_25926("playerUUID");

            context.getPlayer().method_5682().execute(() -> {
                if (favorite) {
                    PlayerMorph.getFavoriteSkinIds(context.getPlayer()).add(skinId);
                } else {
                    PlayerMorph.getFavoriteSkinIds(context.getPlayer()).remove(skinId);
                }
                // re-sync favorites
                sendFavoriteSync((class_3222) context.getPlayer());
            });
        } else {
            class_1299<? extends class_1309> entityType = (class_1299<? extends class_1309>) Walkers.getEntityTypeRegistry().method_10223(Identifier.parse(packet.method_10558("id")));
            int variant = packet.method_10550("variant");

            context.getPlayer().method_5682().execute(() -> {
                @Nullable ShapeType<?> type = ShapeType.from(entityType, variant);

                if (type != null) {
                    if (favorite) {
                        PlayerMorph.getFavoriteShapes(context.getPlayer()).add(type);
                    } else {
                        PlayerMorph.getFavoriteShapes(context.getPlayer()).remove(type);
                    }
                    // resync favorites
                    sendFavoriteSync((class_3222) context.getPlayer());
                }
            });
        }
    }
}
