package tocraft.remorphed.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.craftedcore.patched.CEntity;
import tocraft.craftedcore.patched.Identifier;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.impl.RemorphedPlayerDataProvider;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.variant.ShapeType;

import java.util.*;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

@SuppressWarnings({"DataFlowIssue", "resource", "ControlFlowStatementWithoutBraces", "unused"})
@Mixin(class_1657.class)
public abstract class PlayerEntityMixin extends class_1309 implements RemorphedPlayerDataProvider {
    @Unique
    private final Map<ShapeType<? extends class_1309>, Integer> remorphed$unlockedShapes = new HashMap<>();
    @Unique
    private final Set<ShapeType<?>> remorphed$favoriteShapes = new HashSet<>();
    @Unique
    private final Map<UUID, Integer> remorphed$unlockedSkins = new ConcurrentHashMap<>();
    @Unique
    private final Set<UUID> remorphed$favoriteSkins = new CopyOnWriteArraySet<>();
    @Unique
    private final String UNLOCKED_SHAPES = "UnlockedShapes";
    @Unique
    private final String FAVORITE_SHAPES = "FavoriteShapes";
    @Unique
    private final String UNLOCKED_SKINS = "UnlockedSkins";
    @Unique
    private final String FAVORITE_SKINS = "FavoriteSkins";

    private PlayerEntityMixin(class_1299<? extends class_1309> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method = "tick", at = @At("HEAD"))
    private void serverTick(CallbackInfo info) {
        if (!CEntity.level(this).field_9236) {
            Remorphed.sync((class_3222) (Object) this);
        }
    }

    @Inject(method = "readAdditionalSaveData", at = @At("RETURN"))
    private void readNbt(class_2487 tag, CallbackInfo info) {
        remorphed$readData(tag.method_10562(Remorphed.MODID));
    }

    @Inject(method = "addAdditionalSaveData", at = @At("RETURN"))
    private void writeNbt(class_2487 tag, CallbackInfo info) {
        tag.method_10566(Remorphed.MODID, remorphed$writeData());
    }

    @Unique
    private class_2487 remorphed$writeData() {
        class_2487 tag = new class_2487();
        class_2499 unlockedShapes = new class_2499();
        remorphed$unlockedShapes.forEach((shape, killAmount) -> {
            if (killAmount > 0 && shape != null) {
                class_2487 entryTag = new class_2487();
                entryTag.method_10582("id", Walkers.getEntityTypeRegistry().method_10221(shape.getEntityType()).toString());
                entryTag.method_10569("variant", shape.getVariantData());
                entryTag.method_10569("killAmount", killAmount);
                unlockedShapes.add(entryTag);
            }
        });
        if (!unlockedShapes.isEmpty()) {
            tag.method_10566(UNLOCKED_SHAPES, unlockedShapes);
        }

        class_2499 favoriteShapes = new class_2499();
        remorphed$favoriteShapes.forEach(shape -> {
            if (shape != null) {
                class_2487 entryTag = new class_2487();
                entryTag.method_10582("id", Walkers.getEntityTypeRegistry().method_10221(shape.getEntityType()).toString());
                entryTag.method_10569("variant", shape.getVariantData());
                favoriteShapes.add(entryTag);
            }
        });
        if (!favoriteShapes.isEmpty()) {
            tag.method_10566(FAVORITE_SHAPES, favoriteShapes);
        }

        class_2499 unlockedSkins = new class_2499();
        remorphed$unlockedSkins.forEach((skinId, killAmount) -> {
            if (killAmount > 0 && skinId != null) {
                class_2487 entryTag = new class_2487();
                entryTag.method_25927("uuid", skinId);
                entryTag.method_10569("killAmount", killAmount);
                unlockedSkins.add(entryTag);
            }
        });
        if (!unlockedSkins.isEmpty()) {
            tag.method_10566(UNLOCKED_SKINS, unlockedSkins);
        }

        class_2499 favoriteSkins = new class_2499();
        remorphed$favoriteSkins.forEach(skinId -> {
            if (skinId != null) {
                class_2487 entryTag = new class_2487();
                entryTag.method_25927("uuid", skinId);
                favoriteSkins.add(entryTag);
            }
        });
        if (!favoriteSkins.isEmpty()) {
            tag.method_10566(FAVORITE_SKINS, favoriteSkins);
        }

        return tag;
    }

    @SuppressWarnings("unchecked")
    @Unique
    public void remorphed$readData(class_2487 tag) {
        remorphed$unlockedShapes.clear();
        remorphed$favoriteShapes.clear();
        remorphed$unlockedSkins.clear();
        remorphed$favoriteSkins.clear();

        class_2499 unlockedShapes = tag.method_10554(UNLOCKED_SHAPES, class_2499.field_33260);
        unlockedShapes.forEach(entry -> {
            if (entry instanceof class_2487) {
                class_2960 typeId = Identifier.parse(((class_2487) entry).method_10558("id"));
                int typeVariantId = ((class_2487) entry).method_10550("variant");
                int killAmount = ((class_2487) entry).method_10550("killAmount");

                remorphed$unlockedShapes.put(ShapeType.from((class_1299<? extends class_1309>) Walkers.getEntityTypeRegistry().method_10223(typeId), typeVariantId), killAmount);
            }
        });
        class_2499 favoriteShapes = tag.method_10554(FAVORITE_SHAPES, class_2499.field_33260);
        favoriteShapes.forEach(entry -> {
            if (entry instanceof class_2487) {
                class_2960 typeId = Identifier.parse(((class_2487) entry).method_10558("id"));
                int typeVariantId = ((class_2487) entry).method_10550("variant");

                remorphed$favoriteShapes.add(ShapeType.from((class_1299<? extends class_1309>) Walkers.getEntityTypeRegistry().method_10223(typeId), typeVariantId));
            }
        });

        class_2499 unlockedSkins = tag.method_10554(UNLOCKED_SKINS, class_2499.field_33260);
        unlockedSkins.forEach(entry -> {
            if (entry instanceof class_2487) {
                UUID skinId = ((class_2487) entry).method_25926("uuid");
                int killAmount = ((class_2487) entry).method_10550("killAmount");
                remorphed$unlockedSkins.put(skinId, killAmount);
            }
        });
        class_2499 favoriteSkins = tag.method_10554(FAVORITE_SKINS, class_2499.field_33260);
        favoriteSkins.forEach(entry -> {
            if (entry instanceof class_2487) {
                UUID skinId = ((class_2487) entry).method_25926("uuid");

                remorphed$favoriteSkins.add(skinId);
            }
        });
    }

    @Unique
    @Override
    public Map<ShapeType<? extends class_1309>, Integer> remorphed$getUnlockedShapes() {
        return remorphed$unlockedShapes;
    }

    @Unique
    @Override
    public void remorphed$addKill(ShapeType<? extends class_1309> type) {
        remorphed$unlockedShapes.put(type, remorphed$getKills(type) + 1);
    }

    @Unique
    @Override
    public int remorphed$getKills(ShapeType<? extends class_1309> type) {
        if (Walkers.CONFIG.unlockEveryVariant) {
            int killAmount = 0;
            for (Integer i : remorphed$unlockedShapes.entrySet().stream().filter(entry -> entry.getKey().getEntityType().equals(type.getEntityType())).map(Map.Entry::getValue).toList()) {
                killAmount += i;
            }
            return killAmount;
        } else {
            return remorphed$unlockedShapes.getOrDefault(type, 0);
        }
    }

    @Unique
    @Override
    public Set<ShapeType<?>> remorphed$getFavoriteShapes() {
        return remorphed$favoriteShapes;
    }

    @Unique
    @Override
    public Map<UUID, Integer> remorphed$getUnlockedSkins() {
        return remorphed$unlockedSkins;
    }

    @Unique
    @Override
    public void remorphed$addKill(UUID skinId) {
        remorphed$unlockedSkins.put(skinId, remorphed$getKills(skinId) + 1);
    }

    @Unique
    @Override
    public int remorphed$getKills(UUID skinId) {
        return remorphed$unlockedSkins.getOrDefault(skinId, 0);
    }

    @Unique
    @Override
    public Set<UUID> remorphed$getFavoriteSkins() {
        return remorphed$favoriteSkins;
    }
}
