package tocraft.remorphed.impl;

import com.mojang.authlib.GameProfile;
import dev.tocraft.skinshifter.SkinShifter;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_8685;
import org.jetbrains.annotations.NotNull;
import tocraft.craftedcore.platform.PlayerProfile;

@Environment(EnvType.CLIENT)
public class FakeClientPlayer extends class_742 {
    //#if MC>1201
    private final class_8685 skin;
    
    public FakeClientPlayer(class_638 level, @NotNull PlayerProfile skinProfile) {
        super(level, new GameProfile(skinProfile.id(), skinProfile.name()));
        if (skinProfile.skin() != null) {
            class_2960 skinId = skinProfile.getSkinId();
            class_2960 capeId = SkinShifter.CONFIG.changeCape ? skinProfile.getCapeId() : null;
            class_8685.class_7920 model = skinProfile.isSlim() ? class_8685.class_7920.field_41122 : class_8685.class_7920.field_41123;
            this.skin = new class_8685(skinId, skinProfile.skin().toString(), capeId, null, model, true);
        } else {
            this.skin = super.method_52814();
        }
    }
    
    @Override
    public @NotNull class_8685 method_52814() {
        return this.skin;
    }
    //#else
    //$$ @Nullable
    //$$ private final ResourceLocation skinId;
    //$$ @Nullable
    //$$ private final String modelType;
    //$$ @Nullable
    //$$ private final ResourceLocation cloakId;
    //$$
    //$$ public FakeClientPlayer(ClientLevel clientLevel, @NotNull PlayerProfile skinProfile) {
    //$$     super(clientLevel, new GameProfile(skinProfile.id(), skinProfile.name()));
    //$$
    //$$     if (skinProfile.skin() != null) {
    //$$         skinId = skinProfile.getSkinId();
    //$$         modelType = skinProfile.isSlim() ? "slim" : "default";
    //$$         cloakId = skinProfile.getCapeId();
    //$$     } else {
    //$$         skinId = null;
    //$$         modelType = null;
    //$$         cloakId = null;
    //$$     }
    //$$ }
    //$$
    //$$ @Override
    //$$ public @NotNull ResourceLocation getSkinTextureLocation() {
    //$$     return skinId != null ? skinId : super.getSkinTextureLocation();
    //$$ }
    //$$ @Override
    //$$ public @NotNull String getModelName() {
    //$$     return modelType != null ? modelType : super.getModelName();
    //$$ }
    //$$ @Override
    //$$ public @Nullable ResourceLocation getCloakTextureLocation() {
    //$$     return skinId != null || cloakId != null ? cloakId : super.getCloakTextureLocation();
    //$$ }
    //#endif
}
