package tocraft.remorphed.handler;

import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import tocraft.craftedcore.event.common.EntityEvents;
import tocraft.craftedcore.patched.CEntity;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.impl.PlayerMorph;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.PlayerShapeChanger;
import tocraft.walkers.api.variant.ShapeType;

public class LivingDeathHandler implements EntityEvents.LivingDeath {
    @Override
    public class_1269 die(class_1309 entity, class_1282 source) {
        if (!(entity instanceof class_1657) && source.method_5529() instanceof class_3222 killer) {
            ShapeType<?> type = ShapeType.from(entity);
            if (type != null) {
                PlayerMorph.addKill(killer, type);

                if (Remorphed.CONFIG.autoTransform && PlayerMorph.getKills(killer, type) >= Remorphed.getKillToUnlock(type.getEntityType())) {
                    PlayerShapeChanger.change2ndShape(killer, type);
                    PlayerShape.updateShapes(killer, type.create(CEntity.level(killer)));
                }
            }
        } else if (entity instanceof class_1657 && source.method_5529() instanceof class_3222 killer) {
            PlayerMorph.addPlayerKill(killer, entity.method_5667());
        }

        return class_1269.field_5811;
    }
}
