package tocraft.remorphed.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.tocraft.skinshifter.SkinShifter;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.event.common.CommandEvents;
import tocraft.craftedcore.patched.CCommandSourceStack;
import tocraft.craftedcore.patched.CEntitySummonArgument;
import tocraft.craftedcore.patched.TComponent;
import tocraft.craftedcore.platform.PlayerProfile;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.impl.PlayerMorph;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShapeChanger;
import tocraft.walkers.api.variant.ShapeType;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2170.class_5364;
import net.minecraft.class_2179;
import net.minecraft.class_2186;
import net.minecraft.class_2196;
import net.minecraft.class_2321;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5242;
import net.minecraft.class_7157;

// TODO: Throw when no Player can be found
public class RemorphedCommand implements CommandEvents.CommandRegistration {
    @Override
    //#if MC>1182
    public void register(CommandDispatcher<class_2168> dispatcher, class_7157 registry, class_5364 selection) {
        //#else
        //$$ public void register(CommandDispatcher<CommandSourceStack> dispatcher, Commands.CommandSelection selection) {
        //$$ Object registry = null;
        //#endif

        LiteralCommandNode<class_2168> rootNode = class_2170.method_9247(Remorphed.MODID)
                .requires(source -> source.method_9259(2)).build();

        /*
         * Used to remove a unlocked shape of the specified Player.
         */
        LiteralCommandNode<class_2168> removeShape = class_2170.method_9247("removeShape")
                .then(class_2170.method_9244("player", class_2186.method_9308())
                        .then(class_2170.method_9244("shape", CEntitySummonArgument.id(registry))
                                .suggests(class_2321.field_10935).executes(context -> {
                                    removeShape(context.getSource(), class_2186.method_9315(context, "player"),
                                            CEntitySummonArgument.getEntityTypeId(context, "shape"),
                                            null);
                                    return 1;
                                }).then(class_2170.method_9244("nbt", class_2179.method_9284())
                                        .executes(context -> {
                                            class_2487 nbt = class_2179.method_9285(context, "nbt");

                                            removeShape(context.getSource(),
                                                    class_2186.method_9315(context, "player"),
                                                    CEntitySummonArgument.getEntityTypeId(context, "shape"),
                                                    nbt);

                                            return 1;
                                        }))))
                .build();

        /*
         * Used to add a shape to the specified Player.
         */
        LiteralCommandNode<class_2168> addShape = class_2170.method_9247("addShape")
                .then(class_2170.method_9244("player", class_2186.method_9308())
                        .then(class_2170.method_9244("shape",  CEntitySummonArgument.id(registry))
                                .suggests(class_2321.field_10935).executes(context -> {
                                    addShape(context.getSource(), class_2186.method_9315(context, "player"),
                                            CEntitySummonArgument.getEntityTypeId(context, "shape"),
                                            null);
                                    return 1;
                                }).then(class_2170.method_9244("nbt", class_2179.method_9284())
                                        .executes(context -> {
                                            class_2487 nbt = class_2179.method_9285(context, "nbt");

                                            addShape(context.getSource(),
                                                    class_2186.method_9315(context, "player"),
                                                    CEntitySummonArgument.getEntityTypeId(context, "shape"),
                                                    nbt);

                                            return 1;
                                        }))))
                .build();

        /*
         * Used to remove all unlocked shapes of the specified Player.
         */
        LiteralCommandNode<class_2168> clearShapes = class_2170.method_9247("clearShapes")
                .then(class_2170.method_9244("player", class_2186.method_9308()).executes(context -> {
                    clearShapes(context.getSource(), class_2186.method_9315(context, "player"));
                    return 1;
                })).build();

        /*
         * Used to check if a player has unlocked a specific shape
         */
        LiteralCommandNode<class_2168> hasShape = class_2170.method_9247("hasShape")
                .then(class_2170.method_9244("player", class_2186.method_9308())
                        .then(class_2170.method_9244("shape",  CEntitySummonArgument.id(registry))
                                .suggests(class_2321.field_10935).executes(context -> hasShape(context.getSource(), class_2186.method_9315(context, "player"),
                                        CEntitySummonArgument.getEntityTypeId(context, "shape"),
                                        null)).then(class_2170.method_9244("nbt", class_2179.method_9284())
                                        .executes(context -> {
                                            class_2487 nbt = class_2179.method_9285(context, "nbt");

                                            return hasShape(context.getSource(),
                                                    class_2186.method_9315(context, "player"),
                                                    CEntitySummonArgument.getEntityTypeId(context, "shape"),
                                                    nbt);
                                        }))))
                .build();

        LiteralCommandNode<class_2168> removeSkin = class_2170.method_9247("removeSkin")
                .then(class_2170.method_9244("player", class_2186.method_9308())
                        .then(class_2170.method_9244("playerUUID", class_5242.method_27643())
                                .executes(context -> {
                                    UUID playerUUID = class_5242.method_27645(context, "playerUUID");
                                    class_3222 player = class_2186.method_9315(context, "player");
                                    CompletableFuture.runAsync(() -> {
                                        PlayerProfile playerProfile = PlayerProfile.ofId(playerUUID);
                                        if (playerProfile == null) {
                                            CCommandSourceStack.sendSuccess(context.getSource(), TComponent.translatable("skinshifter.invalid_player", playerUUID), true);
                                        } else {
                                            removeSkin(context.getSource(), player, playerProfile);
                                        }
                                    });
                                    return 1;
                                }))
                        .then(class_2170.method_9244("playerName", class_2196.method_9340())
                                .executes(context -> {
                                    String playerName = class_2196.method_9339(context, "playerName").getString();
                                    class_3222 player = class_2186.method_9315(context, "player");
                                    CompletableFuture.runAsync(() -> {
                                        PlayerProfile playerProfile = PlayerProfile.ofName(playerName);
                                        if (playerProfile == null) {
                                            CCommandSourceStack.sendSuccess(context.getSource(), TComponent.translatable("skinshifter.invalid_player", playerName), true);
                                        } else {
                                            removeSkin(context.getSource(), player, playerProfile);
                                        }
                                    });
                                    return 1;
                                }))).build();

        LiteralCommandNode<class_2168> addSkin = class_2170.method_9247("addSkin")
                .then(class_2170.method_9244("player", class_2186.method_9308())
                        .then(class_2170.method_9244("playerUUID", class_5242.method_27643())
                                .executes(context -> {
                                    UUID playerUUID = class_5242.method_27645(context, "playerUUID");
                                    class_3222 player = class_2186.method_9315(context, "player");
                                    CompletableFuture.runAsync(() -> {
                                        PlayerProfile playerProfile = PlayerProfile.ofId(playerUUID);
                                        if (playerProfile == null) {
                                            CCommandSourceStack.sendSuccess(context.getSource(), TComponent.translatable("skinshifter.invalid_player", playerUUID), true);
                                        } else {
                                            addSkin(context.getSource(), player, playerProfile);
                                        }
                                    });
                                    return 1;
                                }))
                        .then(class_2170.method_9244("playerName", class_2196.method_9340())
                                .executes(context -> {
                                    String playerName = class_2196.method_9339(context, "playerName").getString();
                                    class_3222 player = class_2186.method_9315(context, "player");
                                    CompletableFuture.runAsync(() -> {
                                        PlayerProfile playerProfile = PlayerProfile.ofName(playerName);
                                        if (playerProfile == null) {
                                            CCommandSourceStack.sendSuccess(context.getSource(), TComponent.translatable("skinshifter.invalid_player", playerName), true);
                                        } else {
                                            addSkin(context.getSource(), player, playerProfile);
                                        }
                                    });
                                    return 1;
                                }))).build();

        LiteralCommandNode<class_2168> clearSkins = class_2170.method_9247("clearSkins")
                .then(class_2170.method_9244("player", class_2186.method_9308()).executes(context -> {
                    class_3222 player = class_2186.method_9315(context, "player");
                    clearSkins(context.getSource(), player);
                    return 1;
                })).build();

        /*
         * Used to check if a player has unlocked a specific shape
         */
        LiteralCommandNode<class_2168> hasSkin = class_2170.method_9247("hasSkin")
                .then(class_2170.method_9244("player", class_2186.method_9308())
                        .then(class_2170.method_9244("playerUUID", class_5242.method_27643())
                                .executes(context -> {
                                    UUID playerUUID = class_5242.method_27645(context, "playerUUID");
                                    class_3222 player = class_2186.method_9315(context, "player");
                                    CompletableFuture.runAsync(() -> {
                                        PlayerProfile playerProfile = PlayerProfile.ofId(playerUUID);
                                        if (playerProfile == null) {
                                            CCommandSourceStack.sendSuccess(context.getSource(), TComponent.translatable("skinshifter.invalid_player", playerUUID), true);
                                        } else {
                                            hasSkin(context.getSource(), player, playerProfile);
                                        }
                                    });
                                    return 1;
                                }))
                        .then(class_2170.method_9244("playerName", class_2196.method_9340())
                                .executes(context -> {
                                    String playerName = class_2196.method_9339(context, "playerName").getString();
                                    class_3222 player = class_2186.method_9315(context, "player");
                                    CompletableFuture.runAsync(() -> {
                                        PlayerProfile playerProfile = PlayerProfile.ofName(playerName);
                                        if (playerProfile == null) {
                                            CCommandSourceStack.sendSuccess(context.getSource(), TComponent.translatable("skinshifter.invalid_player", playerName), true);
                                        } else {
                                            hasSkin(context.getSource(), player, playerProfile);
                                        }
                                    });
                                    return 1;
                                }))).build();

        rootNode.addChild(removeShape);
        rootNode.addChild(addShape);
        rootNode.addChild(clearShapes);
        rootNode.addChild(hasShape);

        if (Remorphed.foundSkinShifter) {
            rootNode.addChild(removeSkin);
            rootNode.addChild(addSkin);
            rootNode.addChild(clearSkins);
            rootNode.addChild(hasSkin);
        }

        dispatcher.getRoot().addChild(rootNode);

    }

    private static int hasShape(class_2168 source, class_3222 player, class_2960 id, @Nullable class_2487 nbt) {
        ShapeType<class_1309> type = getType(source.method_9225(), id, nbt);
        class_2561 name = TComponent.translatable(type.getEntityType().method_5882());

        if (PlayerMorph.getUnlockedShapes(player).containsKey(type)) {
            CCommandSourceStack.sendSuccess(source, TComponent.translatable(Remorphed.MODID + ".hasShape_success",
                    player.method_5476(), name), true);

            return 1;
        } else
            CCommandSourceStack.sendSuccess(source, TComponent.translatable(Remorphed.MODID + ".hasShape_fail", player.method_5476(), name), true);

        return 0;
    }

    private static void removeShape(class_2168 source, class_3222 player, class_2960 id, @Nullable class_2487 nbt) {
        ShapeType<class_1309> type = getType(source.method_9225(), id, nbt);
        class_2561 name = TComponent.translatable(type.getEntityType().method_5882());

        PlayerMorph.getUnlockedShapes(player).remove(type);

        CCommandSourceStack.sendSuccess(source, TComponent.translatable(Remorphed.MODID + ".removeShape", name, player.method_5476()), true);
    }

    private static void addShape(class_2168 source, class_3222 player, class_2960 id, @Nullable class_2487 nbt) {
        ShapeType<class_1309> type = getType(source.method_9225(), id, nbt);
        class_2561 name = TComponent.translatable(type.getEntityType().method_5882());

        PlayerMorph.getUnlockedShapes(player).put(type, Remorphed.getKillToUnlock(type.getEntityType()));

        CCommandSourceStack.sendSuccess(source, TComponent.translatable(Remorphed.MODID + ".addShape", player.method_5476(), name), true);
    }

    private static void clearShapes(class_2168 source, class_3222 player) {
        PlayerMorph.getUnlockedShapes(player).clear();

        CCommandSourceStack.sendSuccess(source, TComponent.translatable(Remorphed.MODID + ".clearShapes", player.method_5476()), true);
        PlayerShapeChanger.change2ndShape(player, null);
    }

    @SuppressWarnings("unchecked")
    private static ShapeType<class_1309> getType(class_3218 serverLevel, class_2960 id, @Nullable class_2487 nbt) {
        ShapeType<class_1309> type = ShapeType.from((class_1299<class_1309>) Walkers.getEntityTypeRegistry().method_10223(id));

        if (nbt != null) {
            class_2487 copy = nbt.method_10553();
            copy.method_10582("id", id.toString());
            class_1297 loaded = class_1299.method_17842(copy, serverLevel, it -> it);
            if (loaded instanceof class_1309 living) {
                type = new ShapeType<>(living);
            }
        }

        return type;
    }

    private static void hasSkin(class_2168 source, class_3222 player, PlayerProfile playerProfile) {
        if (PlayerMorph.getUnlockedSkinIds(player).containsKey(playerProfile.id())) {
            CCommandSourceStack.sendSuccess(source, TComponent.translatable(Remorphed.MODID + ".hasSkin_success",
                    player.method_5476(), playerProfile.name()), true);

        } else
            CCommandSourceStack.sendSuccess(source, TComponent.translatable(Remorphed.MODID + ".hasSkin_fail", player.method_5476(), playerProfile.name()), true);

    }

    private static void removeSkin(class_2168 source, class_3222 player, PlayerProfile playerProfile) {
        PlayerMorph.getUnlockedSkinIds(player).remove(playerProfile.id());

        CCommandSourceStack.sendSuccess(source, TComponent.translatable(Remorphed.MODID + ".removeSkin", playerProfile.name(), player.method_5476()), true);
    }

    private static void addSkin(class_2168 source, class_3222 player, PlayerProfile playerProfile) {
        PlayerMorph.getUnlockedSkinIds(player).put(playerProfile.id(), Remorphed.CONFIG.killToUnlockPlayers);

        CCommandSourceStack.sendSuccess(source, TComponent.translatable(Remorphed.MODID + ".addSkin", player.method_5476(), playerProfile.name()), true);
    }

    private static void clearSkins(class_2168 source, class_3222 player) {
        PlayerMorph.getUnlockedSkinIds(player).clear();

        CCommandSourceStack.sendSuccess(source, TComponent.translatable(Remorphed.MODID + ".clearSkins", player.method_5476()), true);
        if (Remorphed.foundSkinShifter) {
            SkinShifter.setSkin(player, null);
        }
    }
}
