package tocraft.remorphed.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_6379;
import net.minecraft.class_7919;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.impl.RemorphedPlayerDataProvider;
import tocraft.remorphed.mixin.accessor.ScreenAccessor;
import tocraft.remorphed.screen.widget.EntityWidget;
import tocraft.remorphed.screen.widget.PlayerWidget;
import tocraft.remorphed.screen.widget.SearchWidget;
import tocraft.remorphed.screen.widget.SpecialShapeWidget;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.variant.ShapeType;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Environment(EnvType.CLIENT)
public class RemorphedScreen extends class_437 {
    private final List<ShapeType<?>> unlocked = new ArrayList<>();
    private final Map<ShapeType<?>, class_1308> renderEntities = new LinkedHashMap<>();
    private final List<EntityWidget<?>> entityWidgets = new ArrayList<>();
    private final SearchWidget searchBar = createSearchBar();
    private final class_4185 helpButton = createHelpButton();
    private final class_4185 variantsButton = createVariantsButton();
    private final PlayerWidget playerButton = createPlayerButton();
    private final SpecialShapeWidget specialShapeButton = createSpecialShapeButton();
    private String lastSearchContents = "";
    private Thread populateUnlocked = null;

    public RemorphedScreen() {
        super(class_2561.method_43470(""));
        super.method_25423(class_310.method_1551(), class_310.method_1551().method_22683().method_4486(), class_310.method_1551().method_22683().method_4502());

        // don't initialize if the player is null
        if (field_22787 == null) return;
        if (field_22787.field_1724 == null) {
            field_22787.method_1507(null);
            return;
        }

        method_37063(searchBar);
        method_37063(helpButton);
        method_37063(variantsButton);
        method_37063(playerButton);
        if (Walkers.hasSpecialShape(field_22787.field_1724.method_5667()))
            method_37063(specialShapeButton);

        populateUnlocked = new Thread(() -> {
            populateUnlockedRenderEntities(field_22787.field_1724);

            // handle favorites
            unlocked.sort((first, second) -> {
                boolean firstIsFav = ((RemorphedPlayerDataProvider) field_22787.field_1724).remorphed$getFavorites().contains(first);
                boolean secondIsFav = ((RemorphedPlayerDataProvider) field_22787.field_1724).remorphed$getFavorites().contains(second);
                if (firstIsFav == secondIsFav)
                    return 0;
                if (firstIsFav)
                    return -1;
                else return 1;
            });

            // filter unlocked
            if (!unlocked.isEmpty() && !Remorphed.displayVariantsInMenu) {
                List<ShapeType<?>> newUnlocked = new ArrayList<>();
                for (ShapeType<?> shapeType : unlocked) {
                    if (!newUnlocked.stream().map(ShapeType::getEntityType).toList().contains(shapeType.getEntityType())) {
                        newUnlocked.add(shapeType);
                    }
                }

                unlocked.clear();
                unlocked.addAll(newUnlocked);
            }
        }, "cache entities");
        populateUnlocked.start();

        // implement search handler
        searchBar.method_1863(text -> {
            method_20086(searchBar);

            // Only re-filter if the text contents changed
            if (!lastSearchContents.equals(text)) {
                ((ScreenAccessor) this).getSelectables().removeIf(button -> button instanceof EntityWidget);
                method_25396().removeIf(button -> button instanceof EntityWidget);
                entityWidgets.clear();

                List<ShapeType<?>> filtered = unlocked
                        .stream()
                        .filter(type -> text.isEmpty() || ShapeType.createTooltipText(renderEntities.get(type)).getString().toUpperCase().contains(text.toUpperCase()) || class_1299.method_5890(type.getEntityType()).toString().toUpperCase().contains(text.toUpperCase()))
                        .collect(Collectors.toList());

                populateEntityWidgets(filtered);
            }

            lastSearchContents = text;
        });
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (populateUnlocked != null && entityWidgets.isEmpty() && !populateUnlocked.isAlive()) {
            populateUnlocked = null;
            // add entity widgets
            populateEntityWidgets(unlocked);
        }

        method_52752(context);

        searchBar.method_25394(context, mouseX, mouseY, delta);
        helpButton.method_25394(context, mouseX, mouseY, delta);
        variantsButton.method_25394(context, mouseX, mouseY, delta);
        playerButton.method_25394(context, mouseX, mouseY, delta);
        if (Walkers.hasSpecialShape(field_22787.field_1724.method_5667()))
            specialShapeButton.method_25394(context, mouseX, mouseY, delta);

        double scaledFactor = this.field_22787.method_22683().method_4495();
        int top = 35;

        context.method_51448().method_22903();
        RenderSystem.enableScissor(
                (int) ((double) 0 * scaledFactor),
                (int) ((double) 0 * scaledFactor),
                (int) ((double) field_22789 * scaledFactor),
                (int) ((double) (this.field_22790 - top) * scaledFactor));

        for (EntityWidget<?> widget : entityWidgets) {
            if (widget.method_46427() + widget.method_25364() > top && widget.method_46427() < getWindow().method_4502()) {
                widget.method_25394(context, mouseX, mouseY, delta);
            }
        }

        RenderSystem.disableScissor();

        context.method_51448().method_22909();
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (!entityWidgets.isEmpty()) {
            float firstPos = entityWidgets.get(0).method_46427();
            EntityWidget<?> lastWidget = entityWidgets.get(entityWidgets.size() - 1);

            // Top section should always have mobs, prevent scrolling the entire list down the screen
            if ((scrollY >= 0 && firstPos >= 35) || (scrollY <= 0 && lastWidget.method_46427() <= getWindow().method_4502() - lastWidget.method_25364())) {
                return false;
            }

            for (class_6379 button : ((ScreenAccessor) this).getSelectables()) {
                if (button instanceof EntityWidget<?> widget) {
                    widget.method_48229(widget.method_46426(), (int) (widget.method_46427() + scrollY * 10));
                }
            }
        }

        return false;
    }

    @SuppressWarnings("unchecked")
    private void populateEntityWidgets(List<ShapeType<?>> rendered) {
        // add widget for each entity to be rendered
        int x = 15;
        int y = 35;
        int rows = (int) Math.ceil(rendered.size() / 7f);

        ShapeType<class_1309> currentType = ShapeType.from(PlayerShape.getCurrentShape(field_22787.field_1724));

        for (int yIndex = 0; yIndex <= rows; yIndex++) {
            for (int xIndex = 0; xIndex < 7; xIndex++) {
                int listIndex = yIndex * 7 + xIndex;

                if (listIndex < rendered.size()) {
                    ShapeType<?> type = rendered.get(listIndex);
                    class_1308 entity = renderEntities.get(type);
                    if (entity != null) {
                        EntityWidget<?> entityWidget = new EntityWidget<>(
                                (getWindow().method_4486() - 27) / 7f * xIndex + x,
                                getWindow().method_4502() / 5f * yIndex + y,
                                (getWindow().method_4486() - 27) / 7f,
                                getWindow().method_4502() / 5f,
                                (ShapeType<class_1308>) type,
                                entity,
                                this,
                                ((RemorphedPlayerDataProvider) field_22787.field_1724).remorphed$getFavorites().contains(type),
                                type.equals(currentType)
                        );

                        method_37063(entityWidget);
                        entityWidgets.add(entityWidget);
                    } else {
                        Remorphed.LOGGER.error("invalid shape type: " + type.getEntityType().method_5882());
                    }
                }
            }
        }
    }

    public synchronized void populateUnlockedRenderEntities(class_1657 player) {
        if (renderEntities.isEmpty() && class_310.method_1551().field_1687 != null) {
            List<ShapeType<?>> validUnlocked = Remorphed.getUnlockedShapes(player);
            for (ShapeType<?> type : validUnlocked) {
                class_1297 entity = type.create(class_310.method_1551().field_1687);
                if (entity instanceof class_1308 living) {
                    unlocked.add(type);
                    renderEntities.put(type, living);
                }
            }

            Remorphed.LOGGER.info(String.format("Loaded %d entities for rendering", unlocked.size()));
        }
    }

    private SearchWidget createSearchBar() {
        return new SearchWidget(
                getWindow().method_4486() / 2f - (getWindow().method_4486() / 4f / 2) - 5,
                5,
                getWindow().method_4486() / 4f,
                20f);
    }

    private class_4185 createHelpButton() {
        class_4185.class_7840 helpButton = class_4185.method_46430(class_2561.method_30163("?"), (widget) -> class_310.method_1551().method_1507(new RemorphedHelpScreen()));

        int xOffset = Walkers.hasSpecialShape(class_310.method_1551().field_1724.method_5667()) ? 30 : 0;

        helpButton.method_46433((int) (getWindow().method_4486() / 2f + (getWindow().method_4486() / 8f) + 35 + xOffset), 5);
        helpButton.method_46437(20, 20);
        helpButton.method_46436(class_7919.method_47407(class_2561.method_43471(Remorphed.MODID + ".help")));
        return helpButton.method_46431();
    }

    private class_4185 createVariantsButton() {
        class_4185.class_7840 variantsButton = class_4185.method_46430(class_2561.method_43471("remorphed.display_variants"), (widget) -> {
            Remorphed.displayVariantsInMenu = !Remorphed.displayVariantsInMenu;
            class_310.method_1551().method_1507(new RemorphedScreen());
        });

        variantsButton.method_46433((int) (getWindow().method_4486() / 2f - (getWindow().method_4486() / 4f / 2) - 110), 5);
        variantsButton.method_46437(100, 20);
        variantsButton.method_46436(class_7919.method_47407(class_2561.method_43471(Remorphed.MODID + ".variants")));

        return variantsButton.method_46431();
    }

    private PlayerWidget createPlayerButton() {
        return new PlayerWidget(
                (int) (getWindow().method_4486() / 2f + (getWindow().method_4486() / 8f) + 5),
                5,
                20,
                20,
                this);
    }

    private SpecialShapeWidget createSpecialShapeButton() {
        return new SpecialShapeWidget(
                (int) (getWindow().method_4486() / 2f + (getWindow().method_4486() / 8f) + 35),
                5,
                20,
                20,
                this);
    }

    private class_1041 getWindow() {
        return class_310.method_1551().method_22683();
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (mouseY < 35) {
            return searchBar.method_25402(mouseX, mouseY, button) || helpButton.method_25402(mouseX, mouseY, button) || variantsButton.method_25402(mouseX, mouseY, button) || playerButton.method_25402(mouseX, mouseY, button) || specialShapeButton.method_25402(mouseX, mouseY, button);
        } else {
            return super.method_25402(mouseX, mouseY, button);
        }
    }
}
