package tocraft.remorphed.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.impl.RemorphedPlayerDataProvider;
import tocraft.walkers.api.variant.ShapeType;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

@Mixin(class_1657.class)
public abstract class PlayerEntityMixin extends class_1309 implements RemorphedPlayerDataProvider {
    @Unique
    private Map<ShapeType<? extends class_1309>, Integer> remorphed$unlockedShapes = new HashMap<>();
    @Unique
    private final Set<ShapeType<?>> remorphed$favoriteShapes = new HashSet<>();
    @Unique
    private final String UNLOCKED_SHAPES = "UnlockedShapes";
    @Unique
    private final String FAVORITE_SHAPES = "FavoriteShapes";

    private PlayerEntityMixin(class_1299<? extends class_1309> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method = "tick", at = @At("HEAD"))
    private void serverTick(CallbackInfo info) {
        if (!method_37908().field_9236)
            Remorphed.sync((class_3222) (Object) this);
    }

    @Inject(method = "readAdditionalSaveData", at = @At("RETURN"))
    private void readNbt(class_2487 tag, CallbackInfo info) {
        remorphed$readData(tag.method_10562(Remorphed.MODID));
    }

    @Inject(method = "addAdditionalSaveData", at = @At("RETURN"))
    private void writeNbt(class_2487 tag, CallbackInfo info) {
        tag.method_10566(Remorphed.MODID, remorphed$writeData());
    }

    @Unique
    private class_2487 remorphed$writeData() {
        class_2487 tag = new class_2487();
        class_2499 unlockedList = new class_2499();
        remorphed$unlockedShapes.forEach((shape, killAmount) -> {
            if (killAmount > 0 && shape != null) {
                class_2487 entryTag = new class_2487();
                entryTag.method_10582("id", class_7923.field_41177.method_10221(shape.getEntityType()).toString());
                entryTag.method_10569("variant", shape.getVariantData());
                entryTag.method_10569("killAmount", killAmount);
                unlockedList.add(entryTag);
            }
        });
        if (!remorphed$unlockedShapes.isEmpty())
            tag.method_10566(UNLOCKED_SHAPES, unlockedList);

        class_2499 favoritesList = new class_2499();
        remorphed$favoriteShapes.forEach(shape -> {
            if (shape != null) {
                class_2487 entryTag = new class_2487();
                entryTag.method_10582("id", class_7923.field_41177.method_10221(shape.getEntityType()).toString());
                entryTag.method_10569("variant", shape.getVariantData());
                favoritesList.add(entryTag);
            }
        });
        if (!remorphed$favoriteShapes.isEmpty())
            tag.method_10566(FAVORITE_SHAPES, favoritesList);

        return tag;
    }

    @SuppressWarnings("unchecked")
    @Unique
    public void remorphed$readData(class_2487 tag) {
        remorphed$unlockedShapes.clear();
        remorphed$favoriteShapes.clear();

        class_2499 unlockedList = tag.method_10554(UNLOCKED_SHAPES, class_2499.field_33260);
        unlockedList.forEach(entry -> {
            if (entry instanceof class_2487) {
                class_2960 typeId = new class_2960(((class_2487) entry).method_10558("id"));
                int typeVariantId = ((class_2487) entry).method_10550("variant");
                int killAmount = ((class_2487) entry).method_10550("killAmount");

                remorphed$unlockedShapes.put(ShapeType.from((class_1299<? extends class_1309>) class_7923.field_41177.method_10223(typeId), typeVariantId), killAmount);
            }
        });
        class_2499 favoritesList = tag.method_10554(FAVORITE_SHAPES, class_2499.field_33260);
        favoritesList.forEach(entry -> {
            if (entry instanceof class_2487) {
                class_2960 typeId = new class_2960(((class_2487) entry).method_10558("id"));
                int typeVariantId = ((class_2487) entry).method_10550("variant");

                remorphed$favoriteShapes.add(ShapeType.from((class_1299<? extends class_1309>) class_7923.field_41177.method_10223(typeId), typeVariantId));
            }
        });
    }

    @Unique
    @Override
    public Map<ShapeType<? extends class_1309>, Integer> remorphed$getUnlockedShapes() {
        return remorphed$unlockedShapes;
    }

    @Unique
    @Override
    public void remorphed$setUnlockedShapes(Map<ShapeType<? extends class_1309>, Integer> types) {
        remorphed$unlockedShapes = types;
    }

    @Unique
    @Override
    public void remorphed$addKill(ShapeType<? extends class_1309> type) {
        remorphed$unlockedShapes.put(type, remorphed$getKills(type) + 1);
    }

    @Unique
    @Override
    public int remorphed$getKills(ShapeType<? extends class_1309> type) {
        return remorphed$unlockedShapes.getOrDefault(type, 0);
    }

    @Unique
    @Override
    public Set<ShapeType<?>> remorphed$getFavorites() {
        return remorphed$favoriteShapes;
    }
}
