package tocraft.remorphed.mixin;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2724;
import net.minecraft.class_310;
import net.minecraft.class_634;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.remorphed.impl.RemorphedPlayerDataProvider;

@Environment(EnvType.CLIENT)
@Mixin(class_634.class)
public abstract class ClientPlayerDataCacheMixin {
    @Shadow
    @Final
    private class_310 minecraft;
    @Unique
    private RemorphedPlayerDataProvider remorphed$dataCache = null;

    // This @Inject caches the custom data attached to this client's player before it
    // is reset when changing dimensions.
    // For example, switching from The End => Overworld will reset the player's NBT.
    @Inject(method = "handleRespawn", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;createPlayer(Lnet/minecraft/client/multiplayer/ClientLevel;Lnet/minecraft/stats/StatsCounter;Lnet/minecraft/client/ClientRecipeBook;ZZ)Lnet/minecraft/client/player/LocalPlayer;"))
    private void beforePlayerReset(class_2724 packet, CallbackInfo ci) {
        remorphed$dataCache = ((RemorphedPlayerDataProvider) minecraft.field_1724);
    }

    // This inject applies data cached from the previous inject.
    // Re-applying on the client will help to prevent sync blips which occur when
    // wiping data and waiting for the server to send a sync packet.
    @Inject(method = "handleRespawn", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/level/Level;dimension()Lnet/minecraft/resources/ResourceKey;", ordinal = 1))
    private void afterPlayerReset(class_2724 packet, CallbackInfo ci) {
        if (remorphed$dataCache != null && minecraft.field_1724 != null) {
            ((RemorphedPlayerDataProvider) minecraft.field_1724).remorphed$setUnlockedShapes(remorphed$dataCache.remorphed$getUnlockedShapes());
            ((RemorphedPlayerDataProvider) minecraft.field_1724).remorphed$getFavorites().clear();
            ((RemorphedPlayerDataProvider) minecraft.field_1724).remorphed$getFavorites().addAll(remorphed$dataCache.remorphed$getFavorites());
        }

        remorphed$dataCache = null;
    }
}