package tocraft.remorphed.network;

import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.impl.RemorphedPlayerDataProvider;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.PlayerShapeChanger;
import tocraft.walkers.api.variant.ShapeType;

import java.util.Set;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7923;

public class NetworkHandler {
    public static final class_2960 SHAPE_REQUEST = Remorphed.id("unlock_request");
    public static final class_2960 UNLOCKED_SYNC = Remorphed.id("unlocked_sync");
    public static final class_2960 FAVORITE_SYNC = Remorphed.id("favorite_sync");
    public static final class_2960 FAVORITE_UPDATE = Remorphed.id("favorite_update");

    public static void registerPacketReceiver() {
        NetworkManager.registerReceiver(NetworkManager.Side.C2S, NetworkHandler.SHAPE_REQUEST, NetworkHandler::handleShapeRequestPacket);
        NetworkManager.registerReceiver(NetworkManager.Side.C2S, FAVORITE_UPDATE, NetworkHandler::handleFavoriteRequestPacket);
    }

    public static <T extends class_1309> void sendSwap2ndShapeRequest(@NotNull ShapeType<T> type) {
        class_2540 buf = new class_2540(Unpooled.buffer());

        class_2487 compound = new class_2487();
        compound.method_10582("id", class_7923.field_41177.method_10221(type.getEntityType()).toString());
        compound.method_10569("variant", type.getVariantData());

        buf.method_10794(compound);

        NetworkManager.sendToServer(NetworkHandler.SHAPE_REQUEST, buf);
    }

    @SuppressWarnings({"ALL"})
    private static void handleShapeRequestPacket(class_2540 packet, NetworkManager.PacketContext context) {
        class_2487 compound = packet.method_10798();

        context.getPlayer().method_5682().execute(() -> {
            // check if player is blacklisted
            if (Walkers.CONFIG.playerUUIDBlacklist.contains(context.getPlayer().method_5667())) {
                context.getPlayer().method_7353(class_2561.method_43471("walkers.player_blacklisted"), true);
                return;
            }

            class_2960 typeId = new class_2960(compound.method_10558("id"));
            int typeVariant = compound.method_10550("variant");

            class_1299<? extends class_1309> eType = (class_1299<? extends class_1309>) class_7923.field_41177.method_10223(typeId);

            // make the default ShapeType null, doing it this way, it's ensured that invalid 2ndShapes won't cause crashes.
            @Nullable
            ShapeType<? extends class_1309> type = ShapeType.from(eType, typeVariant);
            // update Player
            boolean result = PlayerShapeChanger.change2ndShape((class_3222) context.getPlayer(), type);
            if (result && type != null)
                PlayerShape.updateShapes((class_3222) context.getPlayer(), type.create(context.getPlayer().method_37908()));

            // Refresh player dimensions
            context.getPlayer().method_18382();
        });
    }

    public static void sendFavoriteSync(class_3222 player) {
        Set<ShapeType<?>> favorites = ((RemorphedPlayerDataProvider) player).remorphed$getFavorites();
        class_2487 tag = new class_2487();
        class_2499 idList = new class_2499();
        favorites.forEach(type -> idList.add(type.writeCompound()));
        tag.method_10566("FavoriteShapes", idList);

        // Create & send packet with NBT
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.method_10794(tag);
        NetworkManager.sendToPlayer(player, NetworkHandler.FAVORITE_SYNC, packet);
    }

    public static void sendFavoriteRequest(ShapeType<? extends class_1309> type, boolean favorite) {
        class_2540 packet = new class_2540(Unpooled.buffer());
        packet.method_10812(class_7923.field_41177.method_10221(type.getEntityType()));
        packet.writeInt(type.getVariantData());
        packet.writeBoolean(favorite);
        NetworkManager.sendToServer(FAVORITE_UPDATE, packet);
    }

    @SuppressWarnings("ALL")
    private static void handleFavoriteRequestPacket(class_2540 packet, NetworkManager.PacketContext context) {
        class_1299<? extends class_1309> entityType = (class_1299<? extends class_1309>) class_7923.field_41177.method_10223(packet.method_10810());
        int variant = packet.readInt();
        boolean favorite = packet.readBoolean();
        RemorphedPlayerDataProvider playerData = (RemorphedPlayerDataProvider) context.getPlayer();

        context.getPlayer().method_5682().execute(() -> {
            @Nullable ShapeType<?> type = ShapeType.from(entityType, variant);

            if (type != null) {
                if (favorite)
                    playerData.remorphed$getFavorites().add(type);
                else
                    playerData.remorphed$getFavorites().remove(type);
                // resync favorites
                sendFavoriteSync((class_3222) context.getPlayer());
            }
        });
    }
}
