package tocraft.remorphed.network;

import dev.architectury.networking.NetworkManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.client.CraftedCoreClient;
import tocraft.craftedcore.network.client.ClientNetworking.ApplicablePacket;
import tocraft.remorphed.impl.RemorphedPlayerDataProvider;
import tocraft.walkers.api.variant.ShapeType;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

@Environment(EnvType.CLIENT)
public class ClientNetworking {
    public static void registerPacketHandlers() {
        NetworkManager.registerReceiver(NetworkManager.Side.S2C, NetworkHandler.UNLOCKED_SYNC,
                ClientNetworking::handleUnlockedSyncPacket);
        NetworkManager.registerReceiver(NetworkManager.Side.S2C, NetworkHandler.FAVORITE_SYNC, ClientNetworking::handleFavoriteSyncPacket);
    }

    @SuppressWarnings("unchecked")
    public static void handleUnlockedSyncPacket(class_2540 packet, NetworkManager.PacketContext context) {
        final UUID uuid = packet.method_10790();
        final class_2487 compound = packet.method_10798();
        final Map<ShapeType<?>, Integer> unlockedShapes = new HashMap<>();
        if (compound != null && compound.method_10545("UnlockedShapes") && compound.method_10580("UnlockedShapes") instanceof class_2499 list) {
            list.forEach(entryTag -> {
                class_1299<? extends class_1309> eType = (class_1299<? extends class_1309>) class_7923.field_41177.method_10223(new class_2960(((class_2487) entryTag).method_10558("id")));
                int variant = ((class_2487) entryTag).method_10550("variant");
                int killAmount = ((class_2487) entryTag).method_10550("killAmount");
                unlockedShapes.put(ShapeType.from(eType, variant), killAmount);
            });
        }

        runOrQueue(context, player -> {
            @Nullable
            class_1657 syncTarget = player.method_5770().method_18470(uuid);

            if (syncTarget != null)
                ((RemorphedPlayerDataProvider) syncTarget).remorphed$setUnlockedShapes(unlockedShapes);
        });
    }


    private static void handleFavoriteSyncPacket(class_2540 packet, NetworkManager.PacketContext context) {
        class_2487 tag = packet.method_10798();

        if (tag != null) {
            ClientNetworking.runOrQueue(context, player -> {
                RemorphedPlayerDataProvider data = (RemorphedPlayerDataProvider) player;
                data.remorphed$getFavorites().clear();
                class_2499 idList = tag.method_10554("FavoriteShapes", class_2520.field_33260);
                idList.forEach(compound -> data.remorphed$getFavorites().add(ShapeType.from((class_2487) compound)));
            });
        }
    }

    public static void runOrQueue(NetworkManager.PacketContext context, ApplicablePacket packet) {
        if (context.getPlayer() == null) {
            CraftedCoreClient.getSyncPacketQueue().add(packet);
        } else {
            context.queue(() -> packet.apply(context.getPlayer()));
        }
    }
}
