package tocraft.remorphed.events;

import dev.architectury.event.EventResult;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1569;
import net.minecraft.class_3222;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.impl.RemorphedPlayerDataProvider;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.event.ShapeEvents;
import tocraft.walkers.api.variant.ShapeType;

public class UnlockShapeCallback implements ShapeEvents.UnlockShapeCallback {
    @Override
    public EventResult unlock(class_3222 player, ShapeType<?> type) {
        // check if the walkers unlock mechanic should be used
        if (!Remorphed.CONFIG.lockTransform && Remorphed.CONFIG.unlockFriendlyNormal) {
            class_1309 entityToBeUnlocked = type.create(player.method_37908());
            if (!(entityToBeUnlocked instanceof class_1569))
                ((RemorphedPlayerDataProvider) player).remorphed$getUnlockedShapes().put(type, Remorphed.getKillToUnlock(type.getEntityType()));
        }
        // check if entity is unlocked by remorphed, prevents native unlock mechanic by walkers
        else if (!Remorphed.canUseShape(player, type)) {
            if (!Walkers.hasSpecialShape(player.method_5667()) || !type.getEntityType().equals(class_1299.field_6055))
                return EventResult.interruptFalse();
        }

        return EventResult.pass();
    }
}
