package tocraft.remorphed.events;

import dev.architectury.event.EventResult;
import net.minecraft.class_1309;
import net.minecraft.class_1493;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;
import tocraft.remorphed.Remorphed;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.event.ShapeEvents;
import tocraft.walkers.api.variant.ShapeType;

public class ShapeSwapCallback implements ShapeEvents.ShapeSwapCallback {
    @Override
    public EventResult swap(class_3222 player, @Nullable class_1309 to) {
        // check if entity is unlocked by remorphed, prevents native unlocks by walkers
        if (!Remorphed.canUseShape(player, ShapeType.from(to))) {
            // handle special shape
            class_2487 nbt = new class_2487();
            if (Walkers.hasSpecialShape(player.method_5667()) && to instanceof class_1493) {
                to.method_5647(nbt);
                if (nbt.method_10545("isSpecial") && nbt.method_10577("isSpecial")) {
                    return EventResult.pass();
                }
            } else return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }
}
