package tocraft.remorphed.screen.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1299;
import net.minecraft.class_1493;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4264;
import net.minecraft.class_4587;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.impl.RemorphedPlayerDataProvider;
import tocraft.remorphed.network.NetworkHandler;
import tocraft.remorphed.screen.RemorphedScreen;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.variant.ShapeType;
import tocraft.walkers.network.impl.SpecialSwapPackets;

@Environment(EnvType.CLIENT)
public class SpecialShapeWidget extends class_4264 {
    private final RemorphedScreen parent;
    private final boolean isCurrent;
    private final boolean isAvailable;

    public SpecialShapeWidget(int x, int y, int width, int height, RemorphedScreen parent) {
        super(x, y, width, height, class_2561.method_30163(""));
        this.parent = parent;

        // check if current shape is the special shape
        class_2487 nbt = new class_2487();
        if (class_310.method_1551().field_1724 != null && PlayerShape.getCurrentShape(class_310.method_1551().field_1724) instanceof class_1493 wolf)
            wolf.method_5647(nbt);
        this.isCurrent = nbt.method_10545("isSpecial") && nbt.method_10577("isSpecial");
        this.isAvailable = Walkers.CONFIG.specialShapeIsThirdShape || class_310.method_1551().field_1724.method_7337() || ((RemorphedPlayerDataProvider) class_310.method_1551().field_1724).remorphed$getUnlockedShapes().keySet().stream().map(ShapeType::getEntityType).toList().contains(class_1299.field_6055);

        method_47400(class_7919.method_47407(class_2561.method_43471(isAvailable ? "remorphed.special_shape_available" : "remorphed.special_shape_unavailable")));
    }

    @Override
    public void method_48579(class_4587 guiGraphics, int mouseX, int mouseY, float delta) {
        RenderSystem.setShaderTexture(0, Remorphed.id("textures/gui/wolf.png"));
        class_332.method_25293(guiGraphics, method_46426(), method_46427(), method_25368(), method_25364(), 0, 0, 15, 15, 15, 15);

        if (!isCurrent && !isAvailable) {
            RenderSystem.setShaderTexture(0, Remorphed.id("textures/gui/unavailable.png"));
            class_332.method_25293(guiGraphics, method_46426(), method_46427(), method_25368(), method_25364(), 0, 0, 15, 15, 15, 15);
        }
    }

    @Override
    public void method_25306() {
        if (!isCurrent && isAvailable && Walkers.hasSpecialShape(class_310.method_1551().method_1548().method_44717())) {
            if (!Walkers.CONFIG.specialShapeIsThirdShape)
                NetworkHandler.sendSwap2ndShapeRequest(ShapeType.from(class_1299.field_6055, -1));
            SpecialSwapPackets.sendSpecialSwapRequest();
            parent.method_25419();
        }
    }

    @Override
    public void method_47399(class_6382 builder) {

    }
}
