package tocraft.remorphed.screen.widget;

import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4264;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_490;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import net.minecraft.class_898;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.network.NetworkHandler;
import tocraft.remorphed.screen.RemorphedScreen;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.variant.ShapeType;

@Environment(EnvType.CLIENT)
public class EntityWidget<T extends class_1309> extends class_4264 {

    private final ShapeType<T> type;
    private final T entity;
    private final int size;
    private final RemorphedScreen parent;
    private boolean crashed;
    private boolean isFavorite;
    private final boolean isCurrent;

    public EntityWidget(float x, float y, float width, float height, ShapeType<T> type, T entity, RemorphedScreen parent, boolean isFavorite, boolean current) {
        super((int) x, (int) y, (int) width, (int) height, class_2561.method_30163("")); // int x, int y, int width, int height, message
        this.type = type;
        this.entity = entity;
        size = (int) (25 * (1 / (Math.max(entity.method_17682(), entity.method_17681()))));
        entity.method_5834(true);
        this.parent = parent;
        this.isFavorite = isFavorite;
        this.isCurrent = current;
        method_47400(class_7919.method_47407(type.createTooltipText(entity)));
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean bl = mouseX >= (double) this.method_46426() && mouseX < (double) (this.method_46426() + this.field_22758) && mouseY >= (double) this.method_46427() && mouseY < (double) (this.method_46427() + this.field_22759);
        if (bl && class_310.method_1551().field_1724 != null) {
            // switch to new shape
            if (button == 0 && !type.equals(ShapeType.from(PlayerShape.getCurrentShape(class_310.method_1551().field_1724)))) {
                // Update 2nd Shape
                NetworkHandler.sendSwap2ndShapeRequest(type);
                // close active screen handler
                parent.method_25419();
            }
            // Add to favorites
            else if (button == 1) {
                isFavorite = !isFavorite;
                NetworkHandler.sendFavoriteRequest(type, isFavorite);
            }
        }

        return super.method_25402(mouseX, mouseY, button);
    }

    @Override
    public void method_48579(class_4587 context, int mouseX, int mouseY, float delta) {
        if (!crashed) {
            // Some entities (namely Aether mobs) crash when rendered in a GUI.
            // Unsure as to the cause, but this try/catch should prevent the game from entirely dipping out.
            try {
                // ARGH
                class_490.method_2486(context, this.method_46426() + this.method_25368() / 2, (int) (this.method_46427() + this.method_25364() * .75f), size, -10, -10, entity);
            } catch (Exception ignored) {
                crashed = true;
                class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
                immediate.method_22993();
                class_898 entityRenderDispatcher = class_310.method_1551().method_1561();
                entityRenderDispatcher.method_3948(true);
                RenderSystem.getModelViewStack().method_22909();
                class_308.method_24211();
            }

            // Render selected outline
            if (field_22763) {
                RenderSystem.setShaderTexture(0, Remorphed.id("textures/gui/selected.png"));
                class_332.method_25293(context, method_46426(), method_46427(), method_25368(), method_25364(), 0, 0, 48, 32, 48, 32);
            }
            // Render favorite
            if (isFavorite) {
                RenderSystem.setShaderTexture(0, Remorphed.id("textures/gui/favorite.png"));
                class_332.method_25293(context, method_46426(), method_46427(), method_25368(), method_25364(), 0, 0, 48, 32, 48, 32);
            }
        }
    }

    @Override
    public void method_25306() {

    }

    @Override
    public void method_47399(class_6382 builder) {

    }
}
