package tocraft.remorphed.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_7919;
import tocraft.remorphed.Remorphed;
import tocraft.remorphed.impl.RemorphedPlayerDataProvider;
import tocraft.remorphed.mixin.accessor.ScreenAccessor;
import tocraft.remorphed.screen.widget.EntityWidget;
import tocraft.remorphed.screen.widget.PlayerWidget;
import tocraft.remorphed.screen.widget.SearchWidget;
import tocraft.remorphed.screen.widget.SpecialShapeWidget;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.variant.ShapeType;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Environment(EnvType.CLIENT)
public class RemorphedScreen extends class_437 {
    private final List<ShapeType<?>> unlocked = new ArrayList<>();
    private final Map<ShapeType<?>, class_1308> renderEntities = new LinkedHashMap<>();
    private final List<EntityWidget<?>> entityWidgets = new ArrayList<>();
    private final SearchWidget searchBar = createSearchBar();
    private final class_4185 helpButton = createHelpButton();
    private final class_4185 variantsButton = createVariantsButton();
    private final PlayerWidget playerButton = createPlayerButton();
    private final SpecialShapeWidget specialShapeButton = createSpecialShapeButton();
    private String lastSearchContents = "";

    public RemorphedScreen() {
        super(class_2561.method_43470(""));
        super.method_25423(class_310.method_1551(), class_310.method_1551().method_22683().method_4486(), class_310.method_1551().method_22683().method_4502());

        // don't initialize if the player is null
        if (field_22787 == null) return;
        if (field_22787.field_1724 == null) {
            field_22787.method_1507(null);
            return;
        }

        populateRenderEntities();
        method_37063(searchBar);
        method_37063(helpButton);
        method_37063(variantsButton);
        method_37063(playerButton);
        //if (Walkers.hasSpecialShape(minecraft.player.getUUID()))
        method_37063(specialShapeButton);

        unlocked.addAll(collectUnlockedEntities(field_22787.field_1724));

        // handle favorites
        unlocked.sort((first, second) -> {
            boolean firstIsFav = ((RemorphedPlayerDataProvider) field_22787.field_1724).remorphed$getFavorites().contains(first);
            boolean secondIsFav = ((RemorphedPlayerDataProvider) field_22787.field_1724).remorphed$getFavorites().contains(second);
            if (firstIsFav == secondIsFav)
                return 0;
            if (firstIsFav)
                return -1;
            else return 1;
        });
        // add entity widgets
        populateEntityWidgets(unlocked);

        // implement search handler
        searchBar.method_1863(text -> {
            method_20086(searchBar);

            // Only re-filter if the text contents changed
            if (!lastSearchContents.equals(text)) {
                ((ScreenAccessor) this).getSelectables().removeIf(button -> button instanceof EntityWidget);
                method_25396().removeIf(button -> button instanceof EntityWidget);
                entityWidgets.clear();

                List<ShapeType<?>> filtered = unlocked
                        .stream()
                        .filter(type -> text.isEmpty() || type.getEntityType().method_5882().contains(text) || class_1299.method_5890(type.getEntityType()).toString().contains(text))
                        .collect(Collectors.toList());

                populateEntityWidgets(filtered);
            }

            lastSearchContents = text;
        });
    }

    @Override
    public void method_37067() {

    }

    @Override
    public void method_25394(class_4587 context, int mouseX, int mouseY, float delta) {
        method_25420(context);

        searchBar.method_25394(context, mouseX, mouseY, delta);
        helpButton.method_25394(context, mouseX, mouseY, delta);
        variantsButton.method_25394(context, mouseX, mouseY, delta);
        playerButton.method_25394(context, mouseX, mouseY, delta);
        if (Walkers.hasSpecialShape(field_22787.field_1724.method_5667()))
            specialShapeButton.method_25394(context, mouseX, mouseY, delta);
        renderEntityWidgets(context, mouseX, mouseY, delta);
    }

    public void renderEntityWidgets(class_4587 context, int mouseX, int mouseY, float delta) {
        double scaledFactor = this.field_22787.method_22683().method_4495();
        int top = 35;

        context.method_22903();
        RenderSystem.enableScissor(
                (int) ((double) 0 * scaledFactor),
                (int) ((double) 0 * scaledFactor),
                (int) ((double) field_22789 * scaledFactor),
                (int) ((double) (this.field_22790 - top) * scaledFactor));

        entityWidgets.forEach(widget -> widget.method_25394(context, mouseX, mouseY, delta));

        RenderSystem.disableScissor();

        context.method_22909();
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double scrollY) {
        if (!entityWidgets.isEmpty()) {
            float firstPos = entityWidgets.get(0).method_46427();

            // Top section should always have mobs, prevent scrolling the entire list down the screen
            if (scrollY == 1 && firstPos >= 35) {
                return false;
            }

            ((ScreenAccessor) this).getSelectables().forEach(button -> {
                if (button instanceof EntityWidget<?> widget) {
                    widget.method_48229(widget.method_46426(), (int) (widget.method_46427() + scrollY * 10));
                }
            });
        }

        return false;
    }

    @SuppressWarnings("unchecked")
    private void populateEntityWidgets(List<ShapeType<?>> rendered) {
        // add widget for each entity to be rendered
        int x = 15;
        int y = 35;
        int rows = (int) Math.ceil(rendered.size() / 7f);

        ShapeType<class_1309> currentType = ShapeType.from(PlayerShape.getCurrentShape(field_22787.field_1724));

        for (int yIndex = 0; yIndex <= rows; yIndex++) {
            for (int xIndex = 0; xIndex < 7; xIndex++) {
                int listIndex = yIndex * 7 + xIndex;

                if (listIndex < rendered.size()) {
                    ShapeType<?> type = rendered.get(listIndex);

                    // TODO: only render selected type, this will show all eg. sheep
                    EntityWidget<?> entityWidget = new EntityWidget<>(
                            (getWindow().method_4486() - 27) / 7f * xIndex + x,
                            getWindow().method_4502() / 5f * yIndex + y,
                            (getWindow().method_4486() - 27) / 7f,
                            getWindow().method_4502() / 5f,
                            (ShapeType<class_1308>) type,
                            renderEntities.get(type),
                            this,
                            ((RemorphedPlayerDataProvider) field_22787.field_1724).remorphed$getFavorites().contains(type),
                            type.equals(currentType)
                    );

                    method_37063(entityWidget);
                    entityWidgets.add(entityWidget);
                }
            }
        }
    }

    private void populateRenderEntities() {
        if (renderEntities.isEmpty()) {
            List<ShapeType<?>> types = ShapeType.getAllTypes(class_310.method_1551().field_1687, Remorphed.displayVariantsInMenu);
            for (ShapeType<?> type : types) {
                class_1297 entity = type.create(class_310.method_1551().field_1687);
                if (entity instanceof class_1308 living) {
                    renderEntities.put(type, living);
                }
            }

            Remorphed.LOGGER.info(String.format("Loaded %d entities for rendering", types.size()));
        }
    }

    private List<ShapeType<?>> collectUnlockedEntities(class_746 player) {
        List<ShapeType<?>> unlocked = new ArrayList<>();

        // collect current unlocked identities (or allow all for creative users)
        renderEntities.forEach((type, instance) -> {
            if (Remorphed.canUseShape(player, type)) {
                unlocked.add(type);
            }
        });

        return unlocked;
    }

    private SearchWidget createSearchBar() {
        return new SearchWidget(
                getWindow().method_4486() / 2f - (getWindow().method_4486() / 4f / 2) - 5,
                5,
                getWindow().method_4486() / 4f,
                20f);
    }

    private class_4185 createHelpButton() {
        class_4185.class_7840 helpButton = class_4185.method_46430(class_2561.method_30163("?"), (widget) -> class_310.method_1551().method_1507(new RemorphedHelpScreen()));

        int xOffset = Walkers.hasSpecialShape(class_310.method_1551().field_1724.method_5667()) ? 30 : 0;

        helpButton.method_46433((int) (getWindow().method_4486() / 2f + (getWindow().method_4486() / 8f) + 35 + xOffset), 5);
        helpButton.method_46437(20, 20);
        helpButton.method_46436(class_7919.method_47407(class_2561.method_43471(Remorphed.MODID + ".help")));
        return helpButton.method_46431();
    }

    private class_4185 createVariantsButton() {
        class_4185.class_7840 variantsButton = class_4185.method_46430(class_2561.method_43471("remorphed.display_variants"), (widget) -> {
            Remorphed.displayVariantsInMenu = !Remorphed.displayVariantsInMenu;
            class_310.method_1551().method_1507(new RemorphedScreen());
        });

        variantsButton.method_46433((int) (getWindow().method_4486() / 2f - (getWindow().method_4486() / 4f / 2) - 110), 5);
        variantsButton.method_46437(100, 20);
        variantsButton.method_46436(class_7919.method_47407(class_2561.method_43471(Remorphed.MODID + ".variants")));

        return variantsButton.method_46431();
    }

    private PlayerWidget createPlayerButton() {
        return new PlayerWidget(
                (int) (getWindow().method_4486() / 2f + (getWindow().method_4486() / 8f) + 5),
                5,
                20,
                20,
                this);
    }

    private SpecialShapeWidget createSpecialShapeButton() {
        return new SpecialShapeWidget(
                (int) (getWindow().method_4486() / 2f + (getWindow().method_4486() / 8f) + 35),
                5,
                20,
                20,
                this);
    }

    public class_1041 getWindow() {
        return class_310.method_1551().method_22683();
    }

    @Override
    public boolean method_25421() {
        return false;
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (mouseY < 35) {
            return searchBar.method_25402(mouseX, mouseY, button) || helpButton.method_25402(mouseX, mouseY, button) || variantsButton.method_25402(mouseX, mouseY, button) || playerButton.method_25402(mouseX, mouseY, button) || specialShapeButton.method_25402(mouseX, mouseY, button);
        } else {
            return super.method_25402(mouseX, mouseY, button);
        }
    }
}
